/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.TermStructureCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.TermStructureTenorTimeScalingInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class TermStructCovarianceModelFromLIBORCovarianceModelParametric
extends TermStructureCovarianceModelParametric {
    private final TermStructureTenorTimeScalingInterface tenorTimeScalingModel;
    private final AbstractLIBORCovarianceModelParametric covarianceModel;

    public TermStructCovarianceModelFromLIBORCovarianceModelParametric(TermStructureTenorTimeScalingInterface tenorTimeScalingModel, AbstractLIBORCovarianceModelParametric covarianceModel) {
        this.tenorTimeScalingModel = tenorTimeScalingModel;
        this.covarianceModel = covarianceModel;
    }

    @Override
    public double getScaledTenorTime(double periodStart, double periodEnd) {
        if (this.tenorTimeScalingModel == null) {
            return periodEnd - periodStart;
        }
        return this.tenorTimeScalingModel.getScaledTenorTime(periodStart, periodEnd);
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(double time, double periodStart, double periodEnd, TimeDiscretizationInterface periodDiscretization, RandomVariableInterface[] realizationAtTimeIndex, TermStructureModelInterface model) {
        int componentIndex2;
        int componentIndex;
        TimeDiscretizationInterface liborPeriodDiscretization = this.covarianceModel.getLiborPeriodDiscretization();
        int periodStartIndex = liborPeriodDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = liborPeriodDiscretization.getTimeIndex(periodEnd);
        RandomVariableInterface[] factorLoadings = this.covarianceModel.getFactorLoading(time, periodStartIndex, (RandomVariableInterface[])null);
        if (periodEndIndex > periodStartIndex + 1) {
            int factorIndex;
            for (factorIndex = 0; factorIndex < factorLoadings.length; ++factorIndex) {
                factorLoadings[factorIndex] = factorLoadings[factorIndex].mult(liborPeriodDiscretization.getTimeStep(periodStartIndex));
            }
            for (int periodIndex = periodStartIndex + 1; periodIndex < periodEndIndex; ++periodIndex) {
                RandomVariableInterface[] factorLoadingsForPeriod = this.covarianceModel.getFactorLoading(time, periodStartIndex, (RandomVariableInterface[])null);
                double periodLength = liborPeriodDiscretization.getTimeStep(periodIndex);
                for (int factorIndex2 = 0; factorIndex2 < factorLoadings.length; ++factorIndex2) {
                    factorLoadings[factorIndex2] = factorLoadings[factorIndex2].addProduct(factorLoadingsForPeriod[factorIndex2], periodLength);
                }
            }
            for (factorIndex = 0; factorIndex < factorLoadings.length; ++factorIndex) {
                factorLoadings[factorIndex] = factorLoadings[factorIndex].div(periodEnd - periodStart);
            }
        }
        if ((componentIndex = periodDiscretization.getTimeIndex(periodStart)) < 0) {
            componentIndex = -componentIndex - 1 - 1;
        }
        if ((componentIndex2 = periodDiscretization.getTimeIndex(periodEnd)) < 0) {
            componentIndex2 = -componentIndex2 - 1;
        }
        if (componentIndex != componentIndex2 - 1) {
            throw new IllegalArgumentException();
        }
        return factorLoadings;
    }

    @Override
    public int getNumberOfFactors() {
        return this.covarianceModel.getNumberOfFactors();
    }

    @Override
    public double[] getParameter() {
        if (this.tenorTimeScalingModel == null) {
            return this.covarianceModel.getParameter();
        }
        double[] tenorTimeScalingParameter = this.tenorTimeScalingModel.getParameter();
        double[] covarianceParameter = this.covarianceModel.getParameter();
        double[] parameter = new double[tenorTimeScalingParameter.length + covarianceParameter.length];
        System.arraycopy(tenorTimeScalingParameter, 0, parameter, 0, tenorTimeScalingParameter.length);
        System.arraycopy(covarianceParameter, 0, parameter, tenorTimeScalingParameter.length, covarianceParameter.length);
        return parameter;
    }

    @Override
    public TermStructureCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        if (this.tenorTimeScalingModel == null) {
            return new TermStructCovarianceModelFromLIBORCovarianceModelParametric(null, this.covarianceModel.getCloneWithModifiedParameters(parameters));
        }
        double[] tenorTimeScalingParameter = this.tenorTimeScalingModel.getParameter();
        double[] covarianceParameter = this.covarianceModel.getParameter();
        System.arraycopy(parameters, 0, tenorTimeScalingParameter, 0, tenorTimeScalingParameter.length);
        System.arraycopy(parameters, tenorTimeScalingParameter.length, covarianceParameter, 0, covarianceParameter.length);
        return new TermStructCovarianceModelFromLIBORCovarianceModelParametric(this.tenorTimeScalingModel.getCloneWithModifiedParameters(tenorTimeScalingParameter), this.covarianceModel.getCloneWithModifiedParameters(covarianceParameter));
    }

    @Override
    public TermStructureCovarianceModelParametric clone() {
        return new TermStructCovarianceModelFromLIBORCovarianceModelParametric(this.tenorTimeScalingModel.clone(), (AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone());
    }
}

