/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelTwoParameterExponentialForm
extends LIBORVolatilityModel {
    private double a;
    private double b;
    private boolean isCalibrateable = false;

    public LIBORVolatilityModelTwoParameterExponentialForm(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double a, double b) {
        this(timeDiscretization, liborPeriodDiscretization, a, b, true);
    }

    public LIBORVolatilityModelTwoParameterExponentialForm(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double a, double b, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.a = a;
        this.b = b;
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] parameter = new double[]{this.a, this.b};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = parameter[0];
        this.b = parameter[1];
    }

    @Override
    public RandomVariable getVolatility(int timeIndex, int liborIndex) {
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double timeToMaturity = maturity - time;
        double volatilityInstanteaneous = timeToMaturity <= 0.0 ? 0.0 : this.a * Math.exp(-this.b * timeToMaturity);
        return new RandomVariable(this.getTimeDiscretization().getTime(timeIndex), volatilityInstanteaneous);
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelTwoParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.a, this.b, this.isCalibrateable);
    }
}

