/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelTimeHomogenousPiecewiseConstant
extends LIBORVolatilityModel {
    private final TimeDiscretizationInterface timeToMaturityDiscretization;
    private double[] volatility;

    public LIBORVolatilityModelTimeHomogenousPiecewiseConstant(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, TimeDiscretizationInterface timeToMaturityDiscretization, double[] volatility) {
        super(timeDiscretization, liborPeriodDiscretization);
        if (timeToMaturityDiscretization.getTime(0) != 0.0) {
            throw new IllegalArgumentException("timeToMaturityDiscretization should start with 0 as first time point.");
        }
        if (timeToMaturityDiscretization.getNumberOfTimes() != volatility.length) {
            throw new IllegalArgumentException("volatility.length should equal timeToMaturityDiscretization.getNumberOfTimes() .");
        }
        this.timeToMaturityDiscretization = timeToMaturityDiscretization;
        this.volatility = volatility;
    }

    @Override
    public double[] getParameter() {
        return this.volatility;
    }

    @Override
    public void setParameter(double[] parameter) {
        this.volatility = parameter;
    }

    @Override
    public RandomVariableInterface getVolatility(int timeIndex, int liborIndex) {
        double volatilityInstanteaneous;
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double timeToMaturity = maturity - time;
        if (timeToMaturity <= 0.0) {
            volatilityInstanteaneous = 0.0;
        } else {
            int timeIndexTimeToMaturity = this.timeToMaturityDiscretization.getTimeIndex(timeToMaturity);
            if (timeIndexTimeToMaturity < 0) {
                timeIndexTimeToMaturity = -timeIndexTimeToMaturity - 1 - 1;
            }
            if (timeIndexTimeToMaturity < 0) {
                timeIndexTimeToMaturity = 0;
            }
            if (timeIndexTimeToMaturity >= this.timeToMaturityDiscretization.getNumberOfTimes()) {
                --timeIndexTimeToMaturity;
            }
            volatilityInstanteaneous = this.volatility[timeIndexTimeToMaturity];
        }
        if (volatilityInstanteaneous < 0.0) {
            volatilityInstanteaneous = Math.max(volatilityInstanteaneous, 0.0);
        }
        return new RandomVariable(this.getTimeDiscretization().getTime(timeIndex), volatilityInstanteaneous);
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelTimeHomogenousPiecewiseConstant(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.timeToMaturityDiscretization, (double[])this.volatility.clone());
    }
}

