/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModel;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModelFourParameterExponentialForm;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORCovarianceModelExponentialForm5Param
extends AbstractLIBORCovarianceModelParametric {
    private double[] parameter = new double[5];
    private LIBORVolatilityModel volatilityModel;
    private LIBORCorrelationModel correlationModel;

    public LIBORCovarianceModelExponentialForm5Param(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, int numberOfFactors, double[] parameters) {
        super(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
        this.parameter = (double[])parameters.clone();
        this.volatilityModel = new LIBORVolatilityModelFourParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.parameter[0], this.parameter[1], this.parameter[2], this.parameter[3], false);
        this.correlationModel = new LIBORCorrelationModelExponentialDecay(this.getLiborPeriodDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), this.parameter[4], false);
    }

    public LIBORCovarianceModelExponentialForm5Param(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, int numberOfFactors) {
        this(timeDiscretization, liborPeriodDiscretization, numberOfFactors, new double[]{0.2, 0.05, 0.1, 0.2, 0.1});
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelExponentialForm5Param model = new LIBORCovarianceModelExponentialForm5Param(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), this.getParameter());
        model.parameter = this.parameter;
        model.volatilityModel = this.volatilityModel;
        model.correlationModel = this.correlationModel;
        return model;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        LIBORCovarianceModelExponentialForm5Param model = (LIBORCovarianceModelExponentialForm5Param)this.clone();
        model.parameter = parameters;
        if (parameters[0] != this.parameter[0] || parameters[1] != this.parameter[1] || parameters[2] != this.parameter[2] || parameters[3] != this.parameter[3]) {
            model.volatilityModel = new LIBORVolatilityModelFourParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), parameters[0], parameters[1], parameters[2], parameters[3], false);
        }
        if (parameters[4] != this.parameter[4]) {
            model.correlationModel = new LIBORCorrelationModelExponentialDecay(this.getLiborPeriodDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), parameters[4], false);
        }
        return model;
    }

    @Override
    public double[] getParameter() {
        return (double[])this.parameter.clone();
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface[] factorLoading = new RandomVariableInterface[this.correlationModel.getNumberOfFactors()];
        for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
            RandomVariableInterface volatility = this.volatilityModel.getVolatility(timeIndex, component);
            factorLoading[factorIndex] = volatility.mult(this.correlationModel.getFactorLoading(timeIndex, factorIndex, component));
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariableInterface[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }
}

