/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.interestrate.modelplugins.AbstractLIBORCovarianceModelParametric;
import net.finmath.stochastic.RandomVariableInterface;

public class DisplacedLocalVolatilityModel
extends AbstractLIBORCovarianceModelParametric {
    private AbstractLIBORCovarianceModelParametric covarianceModel;
    private double displacement;
    private ForwardCurveInterface forwardCurve;
    private boolean isCalibrateable = false;

    public DisplacedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, double displacement, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.displacement = displacement;
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public Object clone() {
        return new DisplacedLocalVolatilityModel((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.displacement, this.isCalibrateable);
    }

    public AbstractLIBORCovarianceModelParametric getBaseCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        double[] covarianceParameters = this.covarianceModel.getParameter();
        if (covarianceParameters == null) {
            return new double[]{this.displacement};
        }
        double[] jointParameters = new double[covarianceParameters.length + 1];
        System.arraycopy(covarianceParameters, 0, jointParameters, 0, covarianceParameters.length);
        jointParameters[covarianceParameters.length] = this.displacement;
        return jointParameters;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        DisplacedLocalVolatilityModel model = (DisplacedLocalVolatilityModel)this.clone();
        if (parameters == null || parameters.length == 0) {
            return model;
        }
        if (!this.isCalibrateable) {
            model.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(parameters);
            return model;
        }
        double[] covarianceParameters = new double[parameters.length - 1];
        System.arraycopy(parameters, 0, covarianceParameters, 0, covarianceParameters.length);
        model.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(covarianceParameters);
        model.displacement = parameters[covarianceParameters.length];
        return model;
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface[] factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
        if (realizationAtTimeIndex != null && realizationAtTimeIndex[component] != null) {
            RandomVariableInterface localVolatilityFactor = realizationAtTimeIndex[component].add(this.displacement);
            for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                factorLoading[factorIndex] = factorLoading[factorIndex].mult(localVolatilityFactor);
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariableInterface getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariableInterface[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }
}

