/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class AbstractLIBORCovarianceModel {
    private TimeDiscretizationInterface timeDiscretization;
    private TimeDiscretizationInterface liborPeriodDiscretization;
    private int numberOfFactors;

    public AbstractLIBORCovarianceModel(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, int numberOfFactors) {
        this.timeDiscretization = timeDiscretization;
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.numberOfFactors = numberOfFactors;
    }

    public RandomVariableInterface[] getFactorLoading(double time, double component, RandomVariableInterface[] realizationAtTimeIndex) {
        int componentIndex = this.liborPeriodDiscretization.getTimeIndex(component);
        if (componentIndex < 0) {
            componentIndex = -componentIndex - 2;
        }
        return this.getFactorLoading(time, componentIndex, realizationAtTimeIndex);
    }

    public RandomVariableInterface[] getFactorLoading(double time, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        int timeIndex = this.timeDiscretization.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 2;
        }
        return this.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
    }

    public abstract RandomVariableInterface[] getFactorLoading(int var1, int var2, RandomVariableInterface[] var3);

    public abstract RandomVariableInterface getFactorLoadingPseudoInverse(int var1, int var2, int var3, RandomVariableInterface[] var4);

    public RandomVariableInterface getCovariance(double time, int component1, int component2, RandomVariableInterface[] realizationAtTimeIndex) {
        int timeIndex = this.timeDiscretization.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = Math.abs(timeIndex) - 2;
        }
        return this.getCovariance(timeIndex, component1, component2, realizationAtTimeIndex);
    }

    public RandomVariableInterface getCovariance(int timeIndex, int component1, int component2, RandomVariableInterface[] realizationAtTimeIndex) {
        RandomVariableInterface[] factorLoadingOfComponent1 = this.getFactorLoading(timeIndex, component1, realizationAtTimeIndex);
        RandomVariableInterface[] factorLoadingOfComponent2 = this.getFactorLoading(timeIndex, component2, realizationAtTimeIndex);
        RandomVariableInterface covariance = factorLoadingOfComponent1[0].mult(factorLoadingOfComponent2[0]);
        for (int factorIndex = 1; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
            covariance = covariance.addProduct(factorLoadingOfComponent1[factorIndex], factorLoadingOfComponent2[factorIndex]);
        }
        return covariance;
    }

    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }
}

