/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelInterface;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class HullWhiteModelWithConstantCoeff
extends AbstractModel
implements LIBORModelInterface {
    private final TimeDiscretizationInterface liborPeriodDiscretization;
    private String forwardCurveName;
    private AnalyticModelInterface curveModel;
    private ForwardCurveInterface forwardRateCurve;
    private DiscountCurveInterface discountCurve;
    private DiscountCurveInterface discountCurveFromForwardCurve;
    private final double meanReversion;
    private final double volatility;
    private final ConcurrentHashMap<Integer, RandomVariableInterface> numeraires;
    private AbstractProcessInterface numerairesProcess = null;
    private RandomVariableInterface[] initialState;

    public HullWhiteModelWithConstantCoeff(TimeDiscretizationInterface liborPeriodDiscretization, AnalyticModelInterface analyticModel, ForwardCurveInterface forwardRateCurve, DiscountCurveInterface discountCurve, double meanReversion, double volatility, Map<String, ?> properties) {
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.curveModel = analyticModel;
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.meanReversion = meanReversion;
        this.volatility = volatility;
        this.discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(forwardRateCurve);
        this.numeraires = new ConcurrentHashMap();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        if (this.initialState == null) {
            double dt = this.getProcess().getTimeDiscretization().getTimeStep(0);
            this.initialState = new RandomVariableInterface[]{new RandomVariable(Math.log(this.discountCurveFromForwardCurve.getDiscountFactor(0.0) / this.discountCurveFromForwardCurve.getDiscountFactor(dt)) / dt)};
        }
        return this.initialState;
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        RandomVariableInterface numeraire;
        if (time == this.getTime(0)) {
            return new RandomVariable(1.0);
        }
        int timeIndex = this.getProcess().getTimeIndex(time);
        if (timeIndex < 0) {
            int previousTimeIndex = this.getProcess().getTimeIndex(time);
            if (previousTimeIndex < 0) {
                previousTimeIndex = -previousTimeIndex - 1;
            }
            double previousTime = this.getProcess().getTime(--previousTimeIndex);
            RandomVariableInterface value = this.getShortRate(previousTimeIndex);
            RandomVariableInterface integratedRate = value.mult(time - previousTime);
            return this.getNumeraire(previousTime).mult(integratedRate.exp());
        }
        if (this.getProcess() != this.numerairesProcess) {
            this.numeraires.clear();
            this.numerairesProcess = this.getProcess();
        }
        if ((numeraire = this.numeraires.get(timeIndex)) == null) {
            RandomVariableInterface zero;
            RandomVariableInterface integratedRate = zero = this.getProcess().getStochasticDriver().getRandomVariableForConstant(0.0);
            for (int i = 0; i < timeIndex; ++i) {
                RandomVariableInterface rate = this.getShortRate(i);
                double dt = this.getProcess().getTimeDiscretization().getTimeStep(i);
                integratedRate = integratedRate.addProduct(rate, dt);
                numeraire = integratedRate.exp();
                this.numeraires.put(i + 1, numeraire);
            }
        }
        if (this.discountCurve != null) {
            double deterministicNumeraireAdjustment = numeraire.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, time);
            numeraire = numeraire.mult(deterministicNumeraireAdjustment);
        }
        return numeraire;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        double time = this.getProcess().getTime(timeIndex);
        double timeNext = this.getProcess().getTime(timeIndex + 1);
        double t0 = time;
        double t1 = timeNext;
        double t2 = timeIndex < this.getProcess().getTimeDiscretization().getNumberOfTimes() - 2 ? this.getProcess().getTime(timeIndex + 2) : t1 + this.getProcess().getTimeDiscretization().getTimeStep(timeIndex);
        double df0 = this.discountCurveFromForwardCurve.getDiscountFactor(t0);
        double df1 = this.discountCurveFromForwardCurve.getDiscountFactor(t1);
        double df2 = this.discountCurveFromForwardCurve.getDiscountFactor(t2);
        double forward = time > 0.0 ? -Math.log(df1 / df0) / (t1 - t0) : this.getInitialState()[0].get(0);
        double forwardNext = -Math.log(df2 / df1) / (t2 - t1);
        double forwardChange = (forwardNext - forward) / (t1 - t0);
        double meanReversionEffective = this.meanReversion * this.getB(time, timeNext) / (timeNext - time);
        double shortRateVariance = this.getShortRateConditionalVariance(0.0, time);
        double theta = forwardChange + meanReversionEffective * forward + shortRateVariance * this.getB(time, t1) / (t1 - time);
        return new RandomVariableInterface[]{realizationAtTimeIndex[0].mult(-meanReversionEffective).add(theta)};
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int componentIndex, RandomVariableInterface[] realizationAtTimeIndex) {
        double time = this.getProcess().getTime(timeIndex);
        double timeNext = this.getProcess().getTime(timeIndex + 1);
        double scaling = Math.sqrt((1.0 - Math.exp(-2.0 * this.meanReversion * (timeNext - time))) / (2.0 * this.meanReversion * (timeNext - time)));
        double volatilityEffective = scaling * this.volatility;
        return new RandomVariableInterface[]{new RandomVariable(volatilityEffective)};
    }

    @Override
    public RandomVariableInterface getLIBOR(double time, double periodStart, double periodEnd) throws CalculationException {
        return this.getZeroCouponBond(time, periodStart).div(this.getZeroCouponBond(time, periodEnd)).sub(1.0).div(periodEnd - periodStart);
    }

    @Override
    public RandomVariableInterface getLIBOR(int timeIndex, int liborIndex) throws CalculationException {
        return this.getZeroCouponBond(this.getProcess().getTime(timeIndex), this.getLiborPeriod(liborIndex)).div(this.getZeroCouponBond(this.getProcess().getTime(timeIndex), this.getLiborPeriod(liborIndex + 1))).sub(1.0).div(this.getLiborPeriodDiscretization().getTimeStep(liborIndex));
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    @Override
    public int getNumberOfLibors() {
        return this.liborPeriodDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        return this.liborPeriodDiscretization.getTime(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborPeriodDiscretization.getTimeIndex(time);
    }

    @Override
    public AnalyticModelInterface getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurveInterface getDiscountCurve() {
        return this.discountCurve;
    }

    @Override
    public ForwardCurveInterface getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    @Override
    public LIBORMarketModelInterface getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        throw new UnsupportedOperationException();
    }

    private RandomVariableInterface getShortRate(int timeIndex) throws CalculationException {
        RandomVariableInterface value = this.getProcess().getProcessValue(timeIndex, 0);
        return value;
    }

    private RandomVariableInterface getZeroCouponBond(double time, double maturity) throws CalculationException {
        RandomVariableInterface shortRate = this.getShortRate(this.getProcess().getTimeIndex(time));
        return shortRate.mult(-this.getB(time, maturity)).exp().mult(this.getA(time, maturity));
    }

    private double getA(double time, double maturity) {
        double timeStep;
        int timeIndex = this.getProcess().getTimeIndex(time);
        double dt = timeStep = this.getProcess().getTimeDiscretization().getTimeStep(timeIndex);
        double zeroRate = -Math.log(this.discountCurveFromForwardCurve.getDiscountFactor(time + dt) / this.discountCurveFromForwardCurve.getDiscountFactor(time)) / dt;
        double B = this.getB(time, maturity);
        double lnA = Math.log(this.discountCurveFromForwardCurve.getDiscountFactor(maturity) / this.discountCurveFromForwardCurve.getDiscountFactor(time)) + B * zeroRate - 0.5 * this.getShortRateConditionalVariance(0.0, time) * B * B;
        return Math.exp(lnA);
    }

    private double getB(double time, double maturity) {
        return (1.0 - Math.exp(-this.meanReversion * (maturity - time))) / this.meanReversion;
    }

    public double getShortRateConditionalVariance(double time, double maturity) {
        return this.volatility * this.volatility * (1.0 - Math.exp(-2.0 * this.meanReversion * (maturity - time))) / (2.0 * this.meanReversion);
    }

    public double getIntegratedBondSquaredVolatility(double time, double maturity) {
        return this.getShortRateConditionalVariance(0.0, time) * this.getB(time, maturity) * this.getB(time, maturity);
    }
}

