/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.modelling.ModelInterface;
import net.finmath.modelling.ProductInterface;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulationInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class WorstOfExpressCertificate
implements ProductInterface {
    final double maturity;
    final double[] strikeLevels;
    final double[] exerciseDates;
    final double[] triggerPerformanceLevel;
    final double[] redemption;
    final double redemptionFinal;

    public WorstOfExpressCertificate(double maturity, double[] baseLevels, double[] exerciseDates, double[] triggerLevels, double[] redemption, double redemptionFinal) {
        this.maturity = maturity;
        this.strikeLevels = baseLevels;
        this.exerciseDates = exerciseDates;
        this.triggerPerformanceLevel = triggerLevels;
        this.redemption = redemption;
        this.redemptionFinal = redemptionFinal;
    }

    @Override
    public Object getValue(double evaluationTime, ModelInterface model) {
        return null;
    }

    public double getValue(double evaluationTime, HybridAssetLIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface zero = model.getRandomVariableForConstant(0.0);
        RandomVariableInterface values = model.getRandomVariableForConstant(0.0);
        RandomVariableInterface exerciseIndicator = model.getRandomVariableForConstant(1.0);
        for (int triggerIndex = 0; triggerIndex < this.exerciseDates.length; ++triggerIndex) {
            RandomVariableInterface worstPerformance = WorstOfExpressCertificate.getWorstPerformance(model, this.exerciseDates[triggerIndex], this.strikeLevels);
            RandomVariableInterface trigger = worstPerformance.sub(this.triggerPerformanceLevel[triggerIndex]);
            RandomVariableInterface payment = exerciseIndicator.mult(this.redemption[triggerIndex]);
            payment = payment.div(model.getNumeraire(this.exerciseDates[triggerIndex]));
            values = values.add(trigger.barrier(trigger, payment, 0.0));
            exerciseIndicator = exerciseIndicator.barrier(trigger, zero, exerciseIndicator);
        }
        RandomVariableInterface worstPerformance = WorstOfExpressCertificate.getWorstPerformance(model, this.maturity, this.strikeLevels);
        RandomVariableInterface payment = exerciseIndicator.mult(worstPerformance.mult(this.redemptionFinal));
        payment = payment.div(model.getNumeraire(this.maturity));
        values = values.add(payment);
        values = values.mult(model.getNumeraire(evaluationTime));
        return values.getAverage();
    }

    private static RandomVariableInterface getWorstPerformance(HybridAssetLIBORModelMonteCarloSimulationInterface model, double exerciseDate, double[] baseLevels) throws CalculationException {
        RandomVariableInterface worstPerformance = null;
        for (int assetIndex = 0; assetIndex < baseLevels.length; ++assetIndex) {
            RandomVariableInterface underlying = model.getAssetValue(exerciseDate, assetIndex);
            RandomVariableInterface performance = underlying.div(baseLevels[assetIndex]);
            worstPerformance = worstPerformance != null ? worstPerformance.cap(performance) : performance;
        }
        return worstPerformance;
    }
}

