/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class HybridAssetLIBORModelMonteCarloSimulation
implements HybridAssetLIBORModelMonteCarloSimulationInterface {
    private LIBORModelMonteCarloSimulationInterface liborSimulation;
    private AssetModelMonteCarloSimulationInterface assetSimulation;
    private DiscountCurveInterface discountCurve;

    public HybridAssetLIBORModelMonteCarloSimulation(LIBORModelMonteCarloSimulationInterface liborSimulation, AssetModelMonteCarloSimulationInterface assetSimulation, DiscountCurveInterface discountCurve) {
        this.liborSimulation = liborSimulation;
        this.assetSimulation = assetSimulation;
        this.discountCurve = discountCurve;
        if (!liborSimulation.getTimeDiscretization().equals(assetSimulation.getTimeDiscretization())) {
            throw new IllegalArgumentException("The interest rate simulation and the asset simulation need to share the same simulation time discretization.");
        }
    }

    public HybridAssetLIBORModelMonteCarloSimulation(LIBORModelMonteCarloSimulationInterface liborSimulation, AssetModelMonteCarloSimulationInterface assetSimulation) {
        this(liborSimulation, assetSimulation, null);
    }

    @Override
    public int getNumberOfPaths() {
        return this.liborSimulation.getNumberOfPaths();
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.liborSimulation.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.liborSimulation.getNumberOfFactors();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.liborSimulation.getTime(timeIndex);
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        return this.liborSimulation.getLiborPeriodDiscretization();
    }

    @Override
    public int getTimeIndex(double time) {
        return this.liborSimulation.getTimeIndex(time);
    }

    @Override
    public int getNumberOfLibors() {
        return this.liborSimulation.getNumberOfLibors();
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.liborSimulation.getRandomVariableForConstant(value);
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        return this.liborSimulation.getLiborPeriod(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborSimulation.getLiborPeriodIndex(time);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.liborSimulation.getMonteCarloWeights(timeIndex);
    }

    @Override
    public RandomVariableInterface getLIBOR(int timeIndex, int liborIndex) throws CalculationException {
        return this.liborSimulation.getLIBOR(timeIndex, liborIndex);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double time) throws CalculationException {
        return this.liborSimulation.getMonteCarloWeights(time);
    }

    @Override
    public RandomVariableInterface getLIBOR(double time, double periodStart, double periodEnd) throws CalculationException {
        return this.liborSimulation.getLIBOR(time, periodStart, periodEnd);
    }

    @Override
    public HybridAssetLIBORModelMonteCarloSimulation getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        return null;
    }

    @Override
    public RandomVariableInterface[] getLIBORs(int timeIndex) throws CalculationException {
        return this.liborSimulation.getLIBORs(timeIndex);
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        RandomVariableInterface numeraire = this.liborSimulation.getNumeraire(time);
        if (this.discountCurve != null) {
            double deterministicNumeraireAdjustment = numeraire.invert().getAverage() / this.discountCurve.getDiscountFactor(time);
            numeraire = numeraire.mult(deterministicNumeraireAdjustment);
        }
        return numeraire;
    }

    @Override
    public RandomVariableInterface getNumeraire(int timeIndex) throws CalculationException {
        return this.getNumeraire(this.getTime(timeIndex));
    }

    @Override
    public BrownianMotionInterface getBrownianMotion() {
        return this.liborSimulation.getBrownianMotion();
    }

    @Override
    public TermStructureModelInterface getModel() {
        return this.liborSimulation.getModel();
    }

    @Override
    public AbstractProcessInterface getProcess() {
        return this.liborSimulation.getProcess();
    }

    @Override
    public HybridAssetLIBORModelMonteCarloSimulation getCloneWithModifiedSeed(int seed) {
        return null;
    }

    @Override
    public int getNumberOfAssets() {
        return this.assetSimulation.getNumberOfAssets();
    }

    @Override
    public RandomVariableInterface getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.assetSimulation.getAssetValue(timeIndex, assetIndex).mult(this.liborSimulation.getNumeraire(this.getTime(timeIndex))).div(this.assetSimulation.getNumeraire(timeIndex));
    }

    @Override
    public RandomVariableInterface getAssetValue(double time, int assetIndex) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1;
        }
        return this.getAssetValue(timeIndex, assetIndex);
    }
}

