/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class BlackScholesHedgedPortfolio
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double riskFreeRate;
    private final double volatility;
    private final double hedgeOptionMaturity;
    private final double hedgeOptionStrike;
    private final HedgeStrategy hedgeStrategy;

    public BlackScholesHedgedPortfolio(double maturity, double strike, double riskFreeRate, double volatility) {
        this.maturity = maturity;
        this.strike = strike;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.hedgeOptionMaturity = 0.0;
        this.hedgeOptionStrike = 0.0;
        this.hedgeStrategy = HedgeStrategy.deltaHedge;
    }

    public BlackScholesHedgedPortfolio(double maturity, double strike, double riskFreeRate, double volatility, double hedgeOptionMaturity, double hedgeOptionStrike, HedgeStrategy hedgeStrategy) {
        this.maturity = maturity;
        this.strike = strike;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.hedgeOptionMaturity = hedgeOptionMaturity;
        this.hedgeOptionStrike = hedgeOptionStrike;
        this.hedgeStrategy = hedgeStrategy;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, AssetModelMonteCarloSimulationInterface model) throws CalculationException {
        double underlyingValue;
        int path;
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        int numberOfPath = model.getNumberOfPaths();
        double[] amountOfUderlyingAsset = new double[numberOfPath];
        double[] amountOfNumeraireAsset = new double[numberOfPath];
        double[] amountOfHedgeOptions = new double[numberOfPath];
        RandomVariableInterface underlyingToday = model.getAssetValue(0.0, 0);
        double initialValue = underlyingToday.get(0);
        double valueOfOptionAccordingBlackScholes = AnalyticFormulas.blackScholesOptionValue(initialValue, this.riskFreeRate, this.volatility, this.maturity, this.strike);
        Arrays.fill(amountOfNumeraireAsset, valueOfOptionAccordingBlackScholes);
        Arrays.fill(amountOfUderlyingAsset, 0.0);
        Arrays.fill(amountOfHedgeOptions, 0.0);
        for (int timeIndex = 0; timeIndex < timeIndexEvaluationTime; ++timeIndex) {
            RandomVariableInterface underlyingAtTimeIndex = model.getAssetValue(timeIndex, 0);
            RandomVariableInterface numeraireAtTimeIndex = model.getNumeraire(timeIndex);
            for (path = 0; path < model.getNumberOfPaths(); ++path) {
                double newNumberOfNumeraireAsset;
                underlyingValue = underlyingAtTimeIndex.get(path);
                double numeraireValue = numeraireAtTimeIndex.get(path);
                double delta = AnalyticFormulas.blackScholesOptionDelta(underlyingValue, this.riskFreeRate, this.volatility, this.maturity - model.getTime(timeIndex), this.strike);
                double gamma = 0.0;
                if (this.hedgeOptionStrike != 0.0) {
                    gamma = AnalyticFormulas.blackScholesOptionGamma(underlyingValue, this.riskFreeRate, this.volatility, this.maturity - model.getTime(timeIndex), this.strike);
                }
                double vega = 0.0;
                if (this.hedgeOptionStrike != 0.0) {
                    vega = AnalyticFormulas.blackScholesOptionVega(underlyingValue, this.riskFreeRate, this.volatility, this.maturity - model.getTime(timeIndex), this.strike) / (this.maturity - model.getTime(timeIndex));
                }
                double priceOfHedgeOption = AnalyticFormulas.blackScholesOptionValue(underlyingValue, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndex), this.hedgeOptionStrike);
                double deltaOfHedgeOption = AnalyticFormulas.blackScholesOptionDelta(underlyingValue, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndex), this.hedgeOptionStrike);
                double gammaOfHedgeOption = AnalyticFormulas.blackScholesOptionGamma(underlyingValue, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndex), this.hedgeOptionStrike);
                double vegaOfHedgeOption = AnalyticFormulas.blackScholesOptionVega(underlyingValue, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndex), this.hedgeOptionStrike) / (this.hedgeOptionMaturity - model.getTime(timeIndex));
                double newNumberOfHedgeOptions = 0.0;
                switch (this.hedgeStrategy) {
                    case deltaGammaHedge: {
                        newNumberOfHedgeOptions = gamma / gammaOfHedgeOption;
                        break;
                    }
                    case deltaVegaHedge: {
                        newNumberOfHedgeOptions = vega / vegaOfHedgeOption;
                        break;
                    }
                    default: {
                        newNumberOfHedgeOptions = 0.0;
                    }
                }
                if (Double.isNaN(newNumberOfHedgeOptions) || Double.isInfinite(newNumberOfHedgeOptions) || this.maturity - model.getTime(timeIndex) < 0.15) {
                    newNumberOfHedgeOptions = 0.0;
                }
                double hedgeOptionsToBuy = newNumberOfHedgeOptions - amountOfHedgeOptions[path];
                double newNumberOfStocks = delta -= newNumberOfHedgeOptions * deltaOfHedgeOption;
                double stocksToBuy = newNumberOfStocks - amountOfUderlyingAsset[path];
                double numeraireAssetsToBuy = -(stocksToBuy * underlyingValue + hedgeOptionsToBuy * priceOfHedgeOption) / numeraireValue;
                amountOfNumeraireAsset[path] = newNumberOfNumeraireAsset = amountOfNumeraireAsset[path] + numeraireAssetsToBuy;
                amountOfUderlyingAsset[path] = newNumberOfStocks;
                amountOfHedgeOptions[path] = newNumberOfHedgeOptions;
            }
        }
        double[] portfolioValue = new double[numberOfPath];
        RandomVariableInterface underlyingAtEvaluationTime = model.getAssetValue(timeIndexEvaluationTime, 0);
        RandomVariableInterface numeraireAtEvaluationTime = model.getNumeraire(timeIndexEvaluationTime);
        for (path = 0; path < underlyingAtEvaluationTime.size(); ++path) {
            underlyingValue = underlyingAtEvaluationTime.get(path);
            double priceOfHedgeOption = this.hedgeStrategy.equals((Object)HedgeStrategy.deltaHedge) ? 0.0 : AnalyticFormulas.blackScholesOptionValue(underlyingValue, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndexEvaluationTime), this.hedgeOptionStrike);
            portfolioValue[path] = amountOfNumeraireAsset[path] * numeraireAtEvaluationTime.get(path) + amountOfUderlyingAsset[path] * underlyingValue + amountOfHedgeOptions[path] * priceOfHedgeOption;
        }
        return new RandomVariable(evaluationTime, portfolioValue);
    }

    public static enum HedgeStrategy {
        deltaHedge,
        deltaGammaHedge,
        deltaVegaHedge;

    }
}

