/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class BlackScholesDeltaHedgedPortfolio
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double riskFreeRate;
    private final double volatility;

    public BlackScholesDeltaHedgedPortfolio(double maturity, double strike, double riskFreeRate, double volatility) {
        this.maturity = maturity;
        this.strike = strike;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, AssetModelMonteCarloSimulationInterface model) throws CalculationException {
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        RandomVariableInterface underlyingToday = model.getAssetValue(0.0, 0);
        RandomVariableInterface numeraireToday = model.getNumeraire(0.0);
        RandomVariableInterface valueOfOptionAccordingBlackScholes = AnalyticFormulas.blackScholesGeneralizedOptionValue(underlyingToday.mult(Math.exp(this.riskFreeRate * (this.maturity - 0.0))), model.getRandomVariableForConstant(this.volatility), this.maturity - 0.0, this.strike, model.getRandomVariableForConstant(Math.exp(-this.riskFreeRate * (this.maturity - 0.0))));
        RandomVariableInterface amountOfNumeraireAsset = valueOfOptionAccordingBlackScholes.div(numeraireToday);
        RandomVariableInterface amountOfUderlyingAsset = model.getRandomVariableForConstant(0.0);
        for (int timeIndex = 0; timeIndex < timeIndexEvaluationTime; ++timeIndex) {
            RandomVariableInterface newNumberOfNumeraireAsset;
            RandomVariableInterface delta;
            RandomVariableInterface underlyingAtTimeIndex = model.getAssetValue(timeIndex, 0);
            RandomVariableInterface numeraireAtTimeIndex = model.getNumeraire(timeIndex);
            RandomVariableInterface newNumberOfStocks = delta = AnalyticFormulas.blackScholesOptionDelta(underlyingAtTimeIndex, model.getRandomVariableForConstant(this.riskFreeRate), model.getRandomVariableForConstant(this.volatility), this.maturity - model.getTime(timeIndex), this.strike);
            RandomVariableInterface stocksToBuy = newNumberOfStocks.sub(amountOfUderlyingAsset);
            RandomVariableInterface numeraireAssetsToSell = stocksToBuy.mult(underlyingAtTimeIndex).div(numeraireAtTimeIndex);
            amountOfNumeraireAsset = newNumberOfNumeraireAsset = amountOfNumeraireAsset.sub(numeraireAssetsToSell);
            amountOfUderlyingAsset = newNumberOfStocks;
        }
        RandomVariableInterface underlyingAtEvaluationTime = model.getAssetValue(evaluationTime, 0);
        RandomVariableInterface numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface portfolioValue = amountOfNumeraireAsset.mult(numeraireAtEvaluationTime).add(amountOfUderlyingAsset.mult(underlyingAtEvaluationTime));
        return portfolioValue;
    }
}

