/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.Iterator;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class AsianOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final TimeDiscretizationInterface timesForAveraging;
    private final Integer underlyingIndex;

    public AsianOption(double maturity, double strike, TimeDiscretizationInterface timesForAveraging, Integer underlyingIndex) {
        this.maturity = maturity;
        this.strike = strike;
        this.timesForAveraging = timesForAveraging;
        this.underlyingIndex = underlyingIndex;
    }

    public AsianOption(double maturity, double strike, TimeDiscretizationInterface timesForAveraging) {
        this(maturity, strike, timesForAveraging, 0);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, AssetModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface average = model.getRandomVariableForConstant(0.0);
        Iterator iterator = this.timesForAveraging.iterator();
        while (iterator.hasNext()) {
            double time = (Double)iterator.next();
            RandomVariableInterface underlying = model.getAssetValue(time, (int)this.underlyingIndex);
            average = average.add(underlying);
        }
        average = average.div(this.timesForAveraging.getNumberOfTimes());
        RandomVariableInterface values = average.sub(this.strike).floor(0.0);
        RandomVariableInterface numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariableInterface monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariableInterface numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloProbabilitiesAtEvalTime);
        return values;
    }
}

