/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.ArrayList;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.BlackScholesModel;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class MonteCarloBlackScholesModel
implements AssetModelMonteCarloSimulationInterface {
    private final BlackScholesModel model;
    private final double initialValue;
    private final int seed = 3141;

    public MonteCarloBlackScholesModel(TimeDiscretizationInterface timeDiscretization, int numberOfPaths, double initialValue, double riskFreeRate, double volatility) {
        this.initialValue = initialValue;
        this.model = new BlackScholesModel(initialValue, riskFreeRate, volatility);
        ProcessEulerScheme process = new ProcessEulerScheme(new BrownianMotion(timeDiscretization, 1, numberOfPaths, 3141));
        process.setModel(this.model);
        this.model.setProcess(process);
    }

    public MonteCarloBlackScholesModel(double initialValue, double riskFreeRate, double volatility, AbstractProcess process) {
        this.initialValue = initialValue;
        this.model = new BlackScholesModel(initialValue, riskFreeRate, volatility);
        process.setModel(this.model);
        this.model.setProcess(process);
    }

    @Override
    public RandomVariableInterface getAssetValue(double time, int assetIndex) throws CalculationException {
        return this.getAssetValue(this.getTimeIndex(time), assetIndex);
    }

    @Override
    public RandomVariableInterface getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.model.getProcess().getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariableInterface getNumeraire(int timeIndex) throws CalculationException {
        double time = this.getTime(timeIndex);
        return this.model.getNumeraire(time);
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(time);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double time) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialTime = dataModified.get("initialTime") != null ? ((Number)dataModified.get("initialTime")).doubleValue() : this.getTime(0);
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue;
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.model.getRiskFreeRate().getAverage();
        double newVolatility = dataModified.get("volatility") != null ? ((Number)dataModified.get("volatility")).doubleValue() : this.model.getVolatility().getAverage();
        int newSeed = dataModified.get("seed") != null ? ((Number)dataModified.get("seed")).intValue() : 3141;
        BrownianMotionInterface brownianMotion = dataModified.get("seed") != null ? new BrownianMotion(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), newSeed) : (BrownianMotionInterface)this.model.getProcess().getStochasticDriver();
        double timeShift = newInitialTime - this.getTime(0);
        if (timeShift != 0.0) {
            ArrayList<Double> newTimes = new ArrayList<Double>();
            newTimes.add(newInitialTime);
            for (Double time : this.model.getProcess().getStochasticDriver().getTimeDiscretization()) {
                if (!(time > newInitialTime)) continue;
                newTimes.add(time);
            }
            TimeDiscretization newTimeDiscretization = new TimeDiscretization(newTimes);
            brownianMotion = brownianMotion.getCloneWithModifiedTimeDiscretization(newTimeDiscretization);
        }
        ProcessEulerScheme process = new ProcessEulerScheme(brownianMotion);
        return new MonteCarloBlackScholesModel(newInitialValue, newRiskFreeRate, newVolatility, process);
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedSeed(int seed) {
        ProcessEulerScheme process = new ProcessEulerScheme(new BrownianMotion(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), seed));
        return new MonteCarloBlackScholesModel(this.initialValue, this.model.getRiskFreeRate().getAverage(), this.model.getVolatility().getAverage(), process);
    }

    @Override
    public int getNumberOfPaths() {
        return this.model.getProcess().getNumberOfPaths();
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.model.getProcess().getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.model.getProcess().getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.model.getProcess().getTimeIndex(time);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.model.getProcess().getMonteCarloWeights(timeIndex);
    }

    public BlackScholesModel getModel() {
        return this.model;
    }
}

