/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class MonteCarloAssetModel
implements AssetModelMonteCarloSimulationInterface {
    private final AbstractModelInterface model;

    public MonteCarloAssetModel(AbstractModelInterface model, AbstractProcessInterface process) {
        this.model = model;
        process.setModel(model);
        model.setProcess(process);
    }

    @Override
    public RandomVariableInterface getAssetValue(double time, int assetIndex) throws CalculationException {
        return this.getAssetValue(this.getTimeIndex(time), assetIndex);
    }

    @Override
    public RandomVariableInterface getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.model.getProcess().getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariableInterface getNumeraire(int timeIndex) throws CalculationException {
        double time = this.getTime(timeIndex);
        return this.model.getNumeraire(time);
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(time);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double time) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        AbstractProcessInterface newProcess;
        AbstractProcessInterface process = this.model.getProcess();
        AbstractModelInterface newModel = this.model.getCloneWithModifiedData(dataModified);
        try {
            newProcess = process.getCloneWithModifiedData(dataModified);
        }
        catch (UnsupportedOperationException e) {
            newProcess = process;
        }
        if (newModel != this.model && newProcess == process) {
            newProcess = process.clone();
        }
        return new MonteCarloAssetModel(newModel, newProcess);
    }

    @Override
    public AssetModelMonteCarloSimulationInterface getCloneWithModifiedSeed(int seed) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public int getNumberOfPaths() {
        return this.model.getProcess().getNumberOfPaths();
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.model.getProcess().getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.model.getProcess().getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.model.getProcess().getTimeIndex(time);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.model.getProcess().getMonteCarloWeights(timeIndex);
    }

    public AbstractModelInterface getModel() {
        return this.model;
    }
}

