/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Map;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.model.AbstractModel;
import net.finmath.stochastic.RandomVariableInterface;

public class BlackScholesModel
extends AbstractModel {
    private final RandomVariableInterface initialValue;
    private final RandomVariableInterface riskFreeRate;
    private final RandomVariableInterface volatility;
    private final AbstractRandomVariableFactory randomVariableFactory;
    private RandomVariableInterface[] initialState;
    private RandomVariableInterface drift;
    private RandomVariableInterface[] factorLoadings;

    public BlackScholesModel(RandomVariableInterface initialValue, RandomVariableInterface riskFreeRate, RandomVariableInterface volatility, AbstractRandomVariableFactory randomVariableFactory) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.randomVariableFactory = randomVariableFactory;
    }

    public BlackScholesModel(double initialValue, double riskFreeRate, double volatility, AbstractRandomVariableFactory randomVariableFactory) {
        this.initialValue = randomVariableFactory.createRandomVariable(initialValue);
        this.riskFreeRate = randomVariableFactory.createRandomVariable(riskFreeRate);
        this.volatility = randomVariableFactory.createRandomVariable(volatility);
        this.randomVariableFactory = randomVariableFactory;
    }

    public BlackScholesModel(double initialValue, double riskFreeRate, double volatility) {
        this(initialValue, riskFreeRate, volatility, (AbstractRandomVariableFactory)new RandomVariableFactory());
    }

    @Override
    public RandomVariableInterface[] getInitialState() {
        if (this.initialState == null) {
            this.initialState = new RandomVariableInterface[]{this.initialValue.log()};
        }
        return this.initialState;
    }

    @Override
    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        if (this.drift == null) {
            this.drift = this.riskFreeRate.sub(this.volatility.squared().div(2.0));
        }
        return new RandomVariableInterface[]{this.drift};
    }

    @Override
    public RandomVariableInterface[] getFactorLoading(int timeIndex, int component, RandomVariableInterface[] realizationAtTimeIndex) {
        if (this.factorLoadings == null) {
            this.factorLoadings = new RandomVariableInterface[]{this.volatility};
        }
        return this.factorLoadings;
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransform(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariableInterface applyStateSpaceTransformInverse(int componentIndex, RandomVariableInterface randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) {
        return this.riskFreeRate.mult(time).exp();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public BlackScholesModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue.getAverage();
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.getRiskFreeRate().getAverage();
        double newVolatility = dataModified.get("volatility") != null ? ((Number)dataModified.get("volatility")).doubleValue() : this.getVolatility().getAverage();
        return new BlackScholesModel(newInitialValue, newRiskFreeRate, newVolatility, this.randomVariableFactory);
    }

    public String toString() {
        return super.toString() + "\nBlackScholesModel:\n  initial value...:" + this.initialValue + "\n  risk free rate..:" + this.riskFreeRate + "\n  volatiliy.......:" + this.volatility;
    }

    @Override
    public RandomVariableInterface[] getInitialValue() {
        return new RandomVariableInterface[]{this.initialValue};
    }

    public RandomVariableInterface getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public RandomVariableInterface getVolatility() {
        return this.volatility;
    }
}

