/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.Serializable;
import java.util.Arrays;
import net.finmath.functions.PoissonDistribution;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.IndependentIncrementsInterface;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.randomnumbers.MersenneTwister;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class JumpProcessIncrements
implements IndependentIncrementsInterface,
Serializable {
    private static final long serialVersionUID = -5430067621669213475L;
    private final TimeDiscretizationInterface timeDiscretization;
    private final int numberOfPaths;
    private final int seed;
    private final double[] jumpIntensities;
    private final AbstractRandomVariableFactory randomVariableFactory;
    private transient RandomVariableInterface[][] increments;
    private final Object incrementsLazyInitLock = new Object();

    public JumpProcessIncrements(TimeDiscretizationInterface timeDiscretization, double[] jumpIntensities, int numberOfPaths, int seed, AbstractRandomVariableFactory randomVariableFactory) {
        this.timeDiscretization = timeDiscretization;
        this.jumpIntensities = jumpIntensities;
        this.numberOfPaths = numberOfPaths;
        this.seed = seed;
        this.randomVariableFactory = randomVariableFactory;
        this.increments = null;
    }

    public JumpProcessIncrements(TimeDiscretizationInterface timeDiscretization, double[] jumpIntensities, int numberOfPaths, int seed) {
        this(timeDiscretization, jumpIntensities, numberOfPaths, seed, new RandomVariableFactory());
    }

    @Override
    public JumpProcessIncrements getCloneWithModifiedSeed(int seed) {
        return new JumpProcessIncrements(this.getTimeDiscretization(), this.jumpIntensities, this.getNumberOfPaths(), seed);
    }

    @Override
    public JumpProcessIncrements getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface newTimeDiscretization) {
        return new JumpProcessIncrements(newTimeDiscretization, this.jumpIntensities, this.getNumberOfPaths(), this.getSeed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getIncrement(int timeIndex, int factor) {
        Object object = this.incrementsLazyInitLock;
        synchronized (object) {
            if (this.increments == null) {
                this.doGenerateIncrements();
            }
        }
        return this.increments[timeIndex][factor];
    }

    private void doGenerateIncrements() {
        int timeIndex;
        if (this.increments != null) {
            return;
        }
        MersenneTwister mersenneTwister = new MersenneTwister(this.seed);
        double[][][] incrementsArray = new double[this.timeDiscretization.getNumberOfTimeSteps()][this.jumpIntensities.length][this.numberOfPaths];
        PoissonDistribution[][] poissonDistribution = new PoissonDistribution[this.timeDiscretization.getNumberOfTimeSteps()][this.jumpIntensities.length];
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            for (int factorIndex = 0; factorIndex < this.jumpIntensities.length; ++factorIndex) {
                poissonDistribution[timeIndex][factorIndex] = new PoissonDistribution(this.timeDiscretization.getTimeStep(timeIndex) * this.jumpIntensities[factorIndex]);
            }
        }
        for (int pathIndex = 0; pathIndex < this.numberOfPaths; ++pathIndex) {
            for (int timeIndex2 = 0; timeIndex2 < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex2) {
                for (int factorIndex = 0; factorIndex < this.jumpIntensities.length; ++factorIndex) {
                    double numberOfJumps;
                    double uniformIncrement = mersenneTwister.nextDouble();
                    incrementsArray[timeIndex2][factorIndex][pathIndex] = numberOfJumps = poissonDistribution[timeIndex2][factorIndex].inverseCumulativeDistribution(uniformIncrement);
                }
            }
        }
        this.increments = new RandomVariableInterface[this.timeDiscretization.getNumberOfTimeSteps()][this.jumpIntensities.length];
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double time = this.timeDiscretization.getTime(timeIndex + 1);
            for (int factor = 0; factor < this.jumpIntensities.length; ++factor) {
                this.increments[timeIndex][factor] = this.randomVariableFactory.createRandomVariable(time, incrementsArray[timeIndex][factor]);
            }
        }
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.jumpIntensities.length;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    public int getSeed() {
        return this.seed;
    }

    public String toString() {
        return "JumpProcessIncrements [timeDiscretization=" + this.timeDiscretization + ", numberOfPaths=" + this.numberOfPaths + ", seed=" + this.seed + ", jumpIntensities=" + Arrays.toString(this.jumpIntensities) + ", randomVariableFactory=" + this.randomVariableFactory + "]";
    }
}

