/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public interface IndependentIncrementsInterface {
    default public RandomVariableInterface[] getIncrement(int timeIndex) {
        RandomVariableInterface[] increment = new RandomVariableInterface[this.getNumberOfFactors()];
        for (int factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
            increment[factorIndex] = this.getIncrement(timeIndex, factorIndex);
        }
        return increment;
    }

    public RandomVariableInterface getIncrement(int var1, int var2);

    public TimeDiscretizationInterface getTimeDiscretization();

    public int getNumberOfFactors();

    public int getNumberOfPaths();

    public RandomVariableInterface getRandomVariableForConstant(double var1);

    public IndependentIncrementsInterface getCloneWithModifiedSeed(int var1);

    public IndependentIncrementsInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface var1);
}

