/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class SwapAnnuity
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final ScheduleInterface schedule;
    private final String discountCurveName;

    public SwapAnnuity(ScheduleInterface schedule, String discountCurveName) {
        this.schedule = schedule;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModelInterface model) {
        DiscountCurveInterface discountCurve = (DiscountCurveInterface)model.getCurve(this.discountCurveName);
        return SwapAnnuity.getSwapAnnuity(evaluationTime, this.schedule, discountCurve, model);
    }

    public static double getSwapAnnuity(TimeDiscretizationInterface tenor, DiscountCurveInterface discountCurve) {
        return SwapAnnuity.getSwapAnnuity((ScheduleInterface)new RegularSchedule(tenor), discountCurve);
    }

    public static double getSwapAnnuity(TimeDiscretizationInterface tenor, ForwardCurveInterface forwardCurve) {
        return SwapAnnuity.getSwapAnnuity((ScheduleInterface)new RegularSchedule(tenor), forwardCurve);
    }

    public static double getSwapAnnuity(ScheduleInterface schedule, DiscountCurveInterface discountCurve) {
        double evaluationTime = 0.0;
        return SwapAnnuity.getSwapAnnuity(evaluationTime, schedule, discountCurve, null);
    }

    public static double getSwapAnnuity(ScheduleInterface schedule, ForwardCurveInterface forwardCurve) {
        DiscountCurveFromForwardCurve discountCurve = new DiscountCurveFromForwardCurve(forwardCurve.getName());
        double evaluationTime = 0.0;
        return SwapAnnuity.getSwapAnnuity(evaluationTime, schedule, discountCurve, new AnalyticModel(new CurveInterface[]{forwardCurve, discountCurve}));
    }

    public static double getSwapAnnuity(double evaluationTime, ScheduleInterface schedule, DiscountCurveInterface discountCurve, AnalyticModelInterface model) {
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < schedule.getNumberOfPeriods(); ++periodIndex) {
            double paymentDate = schedule.getPayment(periodIndex);
            if (paymentDate <= evaluationTime) continue;
            double periodLength = schedule.getPeriodLength(periodIndex);
            double discountFactor = discountCurve.getDiscountFactor(model, paymentDate);
            value += periodLength * discountFactor;
        }
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }

    public String toString() {
        return "SwapAnnuity [schedule=" + this.schedule + ", discountCurveName=" + this.discountCurveName + "]";
    }
}

