/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class Swap
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final AnalyticProductInterface legReceiver;
    private final AnalyticProductInterface legPayer;

    public Swap(AnalyticProductInterface legReceiver, AnalyticProductInterface legPayer) {
        this.legReceiver = legReceiver;
        this.legPayer = legPayer;
    }

    public Swap(ScheduleInterface scheduleReceiveLeg, String forwardCurveReceiveName, double spreadReceive, String discountCurveReceiveName, ScheduleInterface schedulePayLeg, String forwardCurvePayName, double spreadPay, String discountCurvePayName, boolean isNotionalExchanged) {
        this.legReceiver = new SwapLeg(scheduleReceiveLeg, forwardCurveReceiveName, spreadReceive, discountCurveReceiveName, isNotionalExchanged);
        this.legPayer = new SwapLeg(schedulePayLeg, forwardCurvePayName, spreadPay, discountCurvePayName, isNotionalExchanged);
    }

    public Swap(ScheduleInterface scheduleReceiveLeg, String forwardCurveReceiveName, double spreadReceive, String discountCurveReceiveName, ScheduleInterface schedulePayLeg, String forwardCurvePayName, double spreadPay, String discountCurvePayName) {
        this(scheduleReceiveLeg, forwardCurveReceiveName, spreadReceive, discountCurveReceiveName, schedulePayLeg, forwardCurvePayName, spreadPay, discountCurvePayName, true);
    }

    public Swap(ScheduleInterface scheduleReceiveLeg, double spreadReceive, String discountCurveReceiveName, ScheduleInterface schedulePayLeg, String forwardCurvePayName, String discountCurvePayName) {
        this(scheduleReceiveLeg, null, spreadReceive, discountCurveReceiveName, schedulePayLeg, forwardCurvePayName, 0.0, discountCurvePayName, true);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModelInterface model) {
        double valueReceiverLeg = this.legReceiver.getValue(evaluationTime, model);
        double valuePayerLeg = this.legPayer.getValue(evaluationTime, model);
        return valueReceiverLeg - valuePayerLeg;
    }

    public static double getForwardSwapRate(TimeDiscretizationInterface fixTenor, TimeDiscretizationInterface floatTenor, ForwardCurveInterface forwardCurve) {
        return Swap.getForwardSwapRate(new RegularSchedule(fixTenor), new RegularSchedule(floatTenor), forwardCurve);
    }

    public static double getForwardSwapRate(TimeDiscretizationInterface fixTenor, TimeDiscretizationInterface floatTenor, ForwardCurveInterface forwardCurve, DiscountCurveInterface discountCurve) {
        AnalyticModel model = null;
        if (discountCurve != null) {
            model = new AnalyticModel(new CurveInterface[]{forwardCurve, discountCurve});
        }
        return Swap.getForwardSwapRate(new RegularSchedule(fixTenor), new RegularSchedule(floatTenor), forwardCurve, model);
    }

    public static double getForwardSwapRate(ScheduleInterface fixSchedule, ScheduleInterface floatSchedule, ForwardCurveInterface forwardCurve) {
        return Swap.getForwardSwapRate(fixSchedule, floatSchedule, forwardCurve, null);
    }

    public static double getForwardSwapRate(ScheduleInterface fixSchedule, ScheduleInterface floatSchedule, ForwardCurveInterface forwardCurve, AnalyticModelInterface model) {
        DiscountCurveInterface discountCurve;
        DiscountCurveInterface discountCurveInterface = discountCurve = model == null ? null : model.getDiscountCurve(forwardCurve.getDiscountCurveName());
        if (discountCurve == null) {
            discountCurve = new DiscountCurveFromForwardCurve(forwardCurve.getName());
            model = new AnalyticModel(new CurveInterface[]{forwardCurve, discountCurve});
        }
        double evaluationTime = fixSchedule.getFixing(0);
        double swapAnnuity = SwapAnnuity.getSwapAnnuity(evaluationTime, fixSchedule, discountCurve, model);
        double floatLeg = 0.0;
        for (int periodIndex = 0; periodIndex < floatSchedule.getNumberOfPeriods(); ++periodIndex) {
            double fixing = floatSchedule.getFixing(periodIndex);
            double payment = floatSchedule.getPayment(periodIndex);
            double periodLength = floatSchedule.getPeriodLength(periodIndex);
            double forward = forwardCurve.getForward(model, fixing);
            double discountFactor = discountCurve.getDiscountFactor(model, payment);
            floatLeg += forward * periodLength * discountFactor;
        }
        double valueFloatLeg = floatLeg / discountCurve.getDiscountFactor(model, evaluationTime);
        return valueFloatLeg / swapAnnuity;
    }

    public AnalyticProductInterface getLegReceiver() {
        return this.legReceiver;
    }

    public AnalyticProductInterface getLegPayer() {
        return this.legPayer;
    }

    public String toString() {
        return "Swap [legReceiver=" + this.legReceiver + ", legPayer=" + this.legPayer + "]";
    }
}

