/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;

public class Portfolio
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private ArrayList<AnalyticProductInterface> products = new ArrayList();
    private ArrayList<Double> weights = new ArrayList();

    public Portfolio(List<AnalyticProductInterface> products, List<Double> weights) {
        this.products.addAll(products);
        this.weights.addAll(weights);
    }

    public Portfolio(Portfolio portfolio, List<AnalyticProductInterface> products, List<Double> weights) {
        this.products.addAll(portfolio.getProducts());
        this.weights.addAll(portfolio.getWeights());
        this.products.addAll(products);
        this.weights.addAll(weights);
    }

    public Portfolio(AnalyticProductInterface product, double weight) {
        this.products.add(product);
        this.weights.add(weight);
    }

    public Portfolio(List<AnalyticProductInterface> products) {
        this(products, Collections.nCopies(products.size(), new Double(1.0)));
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModelInterface model) {
        return IntStream.range(0, this.products.size()).parallel().mapToDouble(i -> this.weights.get(i) * this.products.get(i).getValue(evaluationTime, model)).sum();
    }

    public List<AnalyticProductInterface> getProducts() {
        return Collections.unmodifiableList(this.products);
    }

    public List<Double> getWeights() {
        return Collections.unmodifiableList(this.weights);
    }
}

