/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;

public class IndexCurveFromDiscountCurve
extends AbstractCurve
implements CurveInterface {
    private final double indexValue;
    private final DiscountCurveInterface discountCurve;

    public IndexCurveFromDiscountCurve(String name, double indexValue, DiscountCurveInterface discountCurve) {
        super(name, discountCurve.getReferenceDate());
        this.indexValue = indexValue;
        this.discountCurve = discountCurve;
    }

    @Override
    public double[] getParameter() {
        return this.discountCurve.getParameter();
    }

    @Override
    public void setParameter(double[] parameter) {
        this.discountCurve.setParameter(parameter);
    }

    @Override
    public double getValue(AnalyticModelInterface model, double time) {
        return this.indexValue / this.discountCurve.getDiscountFactor(model, time);
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

