/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveNelsonSiegelSvensson;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;
import net.finmath.time.daycount.DayCountConventionInterface;

public class ForwardCurveNelsonSiegelSvensson
extends AbstractCurve
implements Serializable,
ForwardCurveInterface {
    private static final long serialVersionUID = 8024640795839972709L;
    private String paymentOffsetCode;
    private BusinessdayCalendarInterface paymentBusinessdayCalendar;
    private BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention;
    private DayCountConventionInterface daycountConvention;
    private double periodOffset = 0.0;
    private DiscountCurveNelsonSiegelSvensson discountCurve;

    public ForwardCurveNelsonSiegelSvensson(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendarInterface paymentBusinessdayCalendar, BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention, DayCountConventionInterface daycountConvention, double[] parameter, double timeScaling, double periodOffset) {
        super(name, referenceDate);
        this.paymentOffsetCode = paymentOffsetCode;
        this.paymentBusinessdayCalendar = paymentBusinessdayCalendar;
        this.paymentDateRollConvention = paymentDateRollConvention;
        this.daycountConvention = daycountConvention;
        this.periodOffset = periodOffset;
        this.discountCurve = new DiscountCurveNelsonSiegelSvensson(name, referenceDate, parameter, timeScaling);
    }

    public ForwardCurveNelsonSiegelSvensson(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendarInterface paymentBusinessdayCalendar, BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention, DayCountConventionInterface daycountConvention, double[] parameter, double timeScaling) {
        this(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, daycountConvention, parameter, timeScaling, 0.0);
    }

    @Override
    public double getForward(AnalyticModelInterface model, double fixingTime) {
        return this.getForward(model, fixingTime, this.getPaymentOffset(fixingTime + this.periodOffset));
    }

    @Override
    public double getForward(AnalyticModelInterface model, double fixingTime, double paymentOffset) {
        paymentOffset = this.getPaymentOffset(fixingTime + this.periodOffset);
        double daycountFraction = paymentOffset * this.discountCurve.getTimeScaling();
        if (this.daycountConvention != null) {
            LocalDate fixingDate = this.getDateFromModelTime(fixingTime + this.periodOffset);
            LocalDate paymentDate = this.getDateFromModelTime(fixingTime + this.periodOffset + paymentOffset);
            daycountFraction = Math.max(this.daycountConvention.getDaycountFraction(fixingDate, paymentDate), 0.0027397260273972603);
        }
        return (this.discountCurve.getDiscountFactor(model, fixingTime + this.periodOffset) / this.discountCurve.getDiscountFactor(model, fixingTime + this.periodOffset + paymentOffset) - 1.0) / daycountFraction;
    }

    @Override
    public String getDiscountCurveName() {
        return null;
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return new CurveBuilderInterface(){

            @Override
            public CurveInterface build() throws CloneNotSupportedException {
                return ForwardCurveNelsonSiegelSvensson.this;
            }

            @Override
            public CurveBuilderInterface addPoint(double time, double value, boolean isParameter) {
                return this;
            }
        };
    }

    @Override
    public ForwardCurveNelsonSiegelSvensson clone() throws CloneNotSupportedException {
        return (ForwardCurveNelsonSiegelSvensson)super.clone();
    }

    @Override
    public ForwardCurveNelsonSiegelSvensson getCloneForParameter(double[] value) throws CloneNotSupportedException {
        return new ForwardCurveNelsonSiegelSvensson(this.getName(), this.getReferenceDate(), this.paymentOffsetCode, this.paymentBusinessdayCalendar, this.paymentDateRollConvention, this.daycountConvention, value, this.discountCurve.getTimeScaling(), this.periodOffset);
    }

    @Override
    public double getValue(AnalyticModelInterface model, double time) {
        return this.getForward(model, time, this.getPaymentOffset(time));
    }

    @Override
    public double[] getParameter() {
        return this.discountCurve.getParameter();
    }

    public double[] getForwards(AnalyticModelInterface model, double[] fixingTimes) {
        double[] values = new double[fixingTimes.length];
        for (int i = 0; i < fixingTimes.length; ++i) {
            values[i] = this.getForward(model, fixingTimes[i]);
        }
        return values;
    }

    @Override
    public void setParameter(double[] parameter) {
        this.discountCurve.setParameter(parameter);
    }

    @Override
    public double getPaymentOffset(double fixingTime) {
        LocalDate fixingDate = this.getDateFromModelTime(fixingTime);
        LocalDate paymentDate = this.paymentBusinessdayCalendar.getAdjustedDate(fixingDate, this.paymentOffsetCode, this.paymentDateRollConvention);
        double paymentTime = FloatingpointDate.getFloatingPointDateFromDate(this.getReferenceDate(), paymentDate);
        return paymentTime - fixingTime;
    }

    private LocalDate getDateFromModelTime(double fixingTime) {
        return this.getReferenceDate().plusDays((int)Math.round(fixingTime * 365.0));
    }
}

