/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilderInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;

public class DiscountCurveFromProductOfCurves
extends AbstractCurve
implements Serializable,
DiscountCurveInterface {
    private static final long serialVersionUID = 8850409340966149755L;
    private DiscountCurveInterface[] curves;

    public DiscountCurveFromProductOfCurves(String name, LocalDate referenceDate, DiscountCurveInterface ... curves) {
        super(name, referenceDate);
        this.curves = curves;
    }

    @Override
    public double getDiscountFactor(double maturity) {
        return this.getDiscountFactor(null, maturity);
    }

    @Override
    public double getDiscountFactor(AnalyticModelInterface model, double maturity) {
        double discountFactor = 1.0;
        for (DiscountCurveInterface curve : this.curves) {
            discountFactor *= curve.getDiscountFactor(model, maturity);
        }
        return discountFactor;
    }

    @Override
    public double getValue(AnalyticModelInterface model, double time) {
        return this.getDiscountFactor(model, time);
    }

    @Override
    public double[] getParameter() {
        return null;
    }

    @Override
    public void setParameter(double[] parameter) {
    }

    @Override
    public CurveBuilderInterface getCloneBuilder() throws CloneNotSupportedException {
        return null;
    }
}

