/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import net.finmath.fouriermethod.CharacteristicFunctionInterface;
import net.finmath.fouriermethod.models.ProcessCharacteristicFunctionInterface;
import org.apache.commons.math3.complex.Complex;

public class BlackScholesModel
implements ProcessCharacteristicFunctionInterface {
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private final double discountRate;

    public BlackScholesModel(double initialValue, double riskFreeRate, double volatility, double discountRate) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.discountRate = discountRate;
    }

    public BlackScholesModel(double initialValue, double riskFreeRate, double volatility) {
        this(initialValue, riskFreeRate, volatility, riskFreeRate);
    }

    @Override
    public CharacteristicFunctionInterface apply(double time) {
        return argument -> {
            Complex iargument = argument.multiply(Complex.I);
            return iargument.multiply(iargument.multiply(0.5 * this.volatility * this.volatility * time).add(Math.log(this.initialValue) - 0.5 * this.volatility * this.volatility * time + this.riskFreeRate * time)).add(-this.discountRate * time).exp();
        };
    }
}

