/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import net.finmath.fouriermethod.CharacteristicFunctionInterface;
import net.finmath.fouriermethod.models.ProcessCharacteristicFunctionInterface;
import org.apache.commons.math3.complex.Complex;

public class BatesModel
implements ProcessCharacteristicFunctionInterface {
    private final double initialValue;
    private final double riskFreeRate;
    private final double[] volatility;
    private final double discountRate;
    private final double[] alpha;
    private final double[] beta;
    private final double[] sigma;
    private final double[] rho;
    private final double[] lambda;
    private final double k;
    private final double delta;
    private final int numberOfFactors;

    public BatesModel(double initialValue, double riskFreeRate, double[] volatility, double discountRate, double[] alpha, double[] beta, double[] sigma, double[] rho, double[] lambda, double k, double delta) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.discountRate = discountRate;
        this.alpha = alpha;
        this.beta = beta;
        this.sigma = sigma;
        this.rho = rho;
        this.lambda = lambda;
        this.k = k;
        this.delta = delta;
        this.numberOfFactors = alpha.length;
    }

    public BatesModel(double initialValue, double riskFreeRate, double[] volatility, double[] alpha, double[] beta, double[] sigma, double[] rho, double[] lambda, double k, double delta) {
        this(initialValue, riskFreeRate, volatility, riskFreeRate, alpha, beta, sigma, rho, lambda, k, delta);
    }

    public BatesModel(double initialValue, double riskFreeRate, double volatility, double alpha, double beta, double sigma, double rho, double lambdaZero, double lambdaOne, double k, double delta) {
        this(initialValue, riskFreeRate, new double[]{volatility}, new double[]{alpha}, new double[]{beta}, new double[]{sigma}, new double[]{rho}, new double[]{lambdaZero, lambdaOne}, k, delta);
    }

    @Override
    public CharacteristicFunctionInterface apply(final double time) {
        return new CharacteristicFunctionInterface(){

            @Override
            public Complex apply(Complex argument) {
                Complex iargument = argument.multiply(Complex.I);
                Complex C = iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(0.5 * BatesModel.this.delta * BatesModel.this.delta).exp().multiply(new Complex(1.0 + BatesModel.this.k).pow(iargument)).add(-1.0).add(iargument.multiply(-BatesModel.this.k));
                Complex[] gamma = new Complex[BatesModel.this.numberOfFactors];
                Complex[] A = new Complex[BatesModel.this.numberOfFactors];
                Complex[] B = new Complex[BatesModel.this.numberOfFactors];
                for (int i = 0; i < BatesModel.this.numberOfFactors; ++i) {
                    gamma[i] = iargument.multiply(BatesModel.this.rho[i] * BatesModel.this.sigma[i]).subtract(BatesModel.this.beta[i]).pow(2.0).subtract(iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(0.5).add(C.multiply(BatesModel.this.lambda[i + 1])).multiply(2.0 * BatesModel.this.sigma[i] * BatesModel.this.sigma[i])).sqrt();
                    A[i] = iargument.multiply(BatesModel.this.rho[i] * BatesModel.this.sigma[i]).subtract(BatesModel.this.beta[i]).subtract(gamma[i]).multiply(-BatesModel.this.alpha[i] * time / (BatesModel.this.sigma[i] * BatesModel.this.sigma[i])).subtract(iargument.multiply(BatesModel.this.rho[i] * BatesModel.this.sigma[i]).subtract(BatesModel.this.beta[i]).subtract(gamma[i]).multiply(new Complex(1.0).divide(gamma[i].multiply(time).exp()).subtract(1.0).divide(gamma[i])).multiply(0.5).add(new Complex(1.0).divide(gamma[i].multiply(time).exp())).log().add(gamma[i].multiply(time)).multiply(2.0 * BatesModel.this.alpha[i] / (BatesModel.this.sigma[i] * BatesModel.this.sigma[i])));
                    B[i] = iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(0.5).add(C.multiply(BatesModel.this.lambda[i + 1])).multiply(-2).divide(iargument.multiply(BatesModel.this.rho[i] * BatesModel.this.sigma[i]).subtract(BatesModel.this.beta[i]).add(gamma[i].multiply(new Complex(1.0).divide(gamma[i].multiply(time).exp()).add(1.0).divide(new Complex(1.0).divide(gamma[i].multiply(time).exp()).subtract(1.0)))));
                }
                Complex characteristicFunction = A[0].add(B[0].multiply(BatesModel.this.volatility[0])).add(C.multiply(time * BatesModel.this.lambda[0])).add(iargument.multiply(Math.log(BatesModel.this.initialValue) + time * BatesModel.this.riskFreeRate)).add(-BatesModel.this.discountRate * time);
                if (BatesModel.this.numberOfFactors == 2) {
                    characteristicFunction = characteristicFunction.add(A[1]).add(B[1].multiply(BatesModel.this.volatility[1]));
                }
                characteristicFunction = characteristicFunction.exp();
                return characteristicFunction;
            }
        };
    }
}

