/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neoitertools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.ericaro.neoitertools.Couple;
import net.ericaro.neoitertools.Index;
import net.ericaro.neoitertools.Iterators;
import net.ericaro.neoitertools.Mapper;
import net.ericaro.neoitertools.Operator;
import net.ericaro.neoitertools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterables {
    public static <T> boolean all(Iterable<T> iterable, Predicate<T> predicate) {
        return Iterators.all(iterable.iterator(), predicate);
    }

    public static <T> boolean any(Iterable<T> iterable, Predicate<T> predicate) {
        return Iterators.any(iterable.iterator(), predicate);
    }

    public static <T> List<T> asList(Iterable<T> iterable) {
        return Iterators.asList(iterable.iterator());
    }

    public static String asString(Iterable<Character> chars) {
        return Iterables.asStringBuilder(chars).toString();
    }

    public static StringBuilder asStringBuilder(Iterable<Character> chars) {
        StringBuilder sb = new StringBuilder();
        for (Character c : chars) {
            sb.append(c.charValue());
        }
        return sb;
    }

    public static <T> Iterable<T> chain(final Iterable<Iterable<T>> iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.chain(Iterables.map(new Iterable2IteratorMapper(), iterables).iterator());
            }
        };
    }

    public static <T> Iterable<T> chain(Iterable<T> i1, Iterable<T> i2) {
        ArrayList<Iterable<T>> list = new ArrayList<Iterable<T>>();
        list.add(i1);
        list.add(i2);
        return Iterables.chain(list);
    }

    public static Iterable<Integer> count() {
        return Iterables.count(0);
    }

    public static Iterable<Integer> count(final int n) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return Iterators.count(n);
            }
        };
    }

    public static <T> Iterable<T> dropwhile(final Iterable<T> iterable, final Predicate<T> predicate) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.dropwhile(iterable.iterator(), predicate);
            }
        };
    }

    public static <T> Iterable<Index<T>> enumerate(final Iterable<T> iterable) {
        return new Iterable<Index<T>>(){

            @Override
            public Iterator<Index<T>> iterator() {
                return Iterators.enumerate(iterable.iterator());
            }
        };
    }

    public static <T> Iterable<T> filter(final Predicate<T> predicate, final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(predicate, iterable.iterator());
            }
        };
    }

    public static <T> Iterable<T> filterfalse(final Predicate<T> predicate, final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filterfalse(predicate, iterable.iterator());
            }
        };
    }

    public static Iterable<Character> iter(final CharSequence s) {
        return new Iterable<Character>(){

            @Override
            public Iterator<Character> iterator() {
                return Iterators.iter(s);
            }
        };
    }

    public static Iterable<Byte> iter(final byte[] array) {
        return new Iterable<Byte>(){

            @Override
            public Iterator<Byte> iterator() {
                return Iterators.iter(array);
            }
        };
    }

    public static Iterable<Character> iter(final char[] array) {
        return new Iterable<Character>(){

            @Override
            public Iterator<Character> iterator() {
                return Iterators.iter(array);
            }
        };
    }

    public static Iterable<Short> iter(final short[] array) {
        return new Iterable<Short>(){

            @Override
            public Iterator<Short> iterator() {
                return Iterators.iter(array);
            }
        };
    }

    public static Iterable<Integer> iter(final int[] array) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return Iterators.iter(array);
            }
        };
    }

    public static Iterable<Long> iter(final long[] array) {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return Iterators.iter(array);
            }
        };
    }

    public static Iterable<Float> iter(final float[] array) {
        return new Iterable<Float>(){

            @Override
            public Iterator<Float> iterator() {
                return Iterators.iter(array);
            }
        };
    }

    public static Iterable<Double> iter(final double[] array) {
        return new Iterable<Double>(){

            @Override
            public Iterator<Double> iterator() {
                return Iterators.iter(array);
            }
        };
    }

    public static Iterable<Boolean> iter(final boolean[] array) {
        return new Iterable<Boolean>(){

            @Override
            public Iterator<Boolean> iterator() {
                return Iterators.iter(array);
            }
        };
    }

    public static <T> Iterable<T> iter(T[] t) {
        return Arrays.asList(t);
    }

    public static <T> List<T> list(Iterable<T> iterable) {
        LinkedList<T> list = new LinkedList<T>();
        for (T t : iterable) {
            list.add(t);
        }
        return list;
    }

    public static <I, O> Iterable<O> map(final Mapper<I, O> mapper, final Iterable<I> iterable) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return Iterators.map(mapper, iterable.iterator());
            }
        };
    }

    public static Iterable<Integer> range(int end) {
        return Iterables.range(0, end, 1);
    }

    public static Iterable<Integer> range(int start, int end) {
        return Iterables.range(start, end, 1);
    }

    public static Iterable<Integer> range(final int start, final int end, final int step) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return Iterators.range(start, end, step);
            }
        };
    }

    public static <T> T reduce(Operator<T> operator, Iterable<T> iterable) {
        return Iterables.reduce(operator, iterable, null);
    }

    public static <T> T reduce(Operator<T> operator, Iterable<T> iterable, T initializer) {
        return Iterators.reduce(operator, iterable.iterator(), initializer);
    }

    public static <T> Iterable<T> slice(Iterable<T> iterable, int stop) {
        return Iterables.slice(iterable, 0, stop, 1);
    }

    public static <T> Iterable<T> slice(Iterable<T> iterable, int start, int stop) {
        return Iterables.slice(iterable, start, stop, 1);
    }

    public static <T> Iterable<T> slice(final Iterable<T> iterable, final int start, final int stop, final int step) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.slice(iterable.iterator(), start, stop, step);
            }
        };
    }

    public static <T extends Comparable<? super T>> Iterable<T> sorted(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.sorted(iterable.iterator());
            }
        };
    }

    public static <T, K> Iterable<T> sorted(final Iterable<T> iterable, final Mapper<T, K> key, final Comparator<? super K> cmp, final boolean reverse) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.sorted(iterable.iterator(), cmp, key, reverse);
            }
        };
    }

    public static <T> Iterable<T> sorted(final Iterable<T> iterable, final Comparator<? super T> cmp) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.sorted(iterable.iterator(), cmp);
            }
        };
    }

    public static <T, K extends Comparable<? super K>> Iterable<T> sorted(final Iterable<T> iterable, final Mapper<T, K> key, final boolean reverse) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.sorted(iterable.iterator(), key, reverse);
            }
        };
    }

    public static <T> List<T> tuple(Iterable<T> iterable) {
        return Collections.unmodifiableList(Iterables.list(iterable));
    }

    public static <T> Iterable<List<T>> zip(final Iterable<Iterable<T>> iterables) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.zip(Iterables.map(new Iterable2IteratorMapper(), iterables).iterator());
            }
        };
    }

    public static <T1, T2> Iterable<Couple<T1, T2>> zip(final Iterable<T1> iterable1, final Iterable<T2> iterable2) {
        return new Iterable<Couple<T1, T2>>(){

            @Override
            public Iterator<Couple<T1, T2>> iterator() {
                return Iterators.zip(iterable1.iterator(), iterable2.iterator());
            }
        };
    }

    public <T> Iterable<T> reversed(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.reversed(iterable.iterator());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Iterable2IteratorMapper<T>
    implements Mapper<Iterable<T>, Iterator<T>> {
        protected Iterable2IteratorMapper() {
        }

        @Override
        public Iterator<T> map(Iterable<T> arg) {
            return arg.iterator();
        }
    }
}

