/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.check;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.devh.boot.grpc.server.security.check.AccessPredicates;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public interface AccessPredicate
extends Predicate<Authentication> {
    default public AccessPredicate negate() {
        return t -> !this.test(t);
    }

    default public AccessPredicate and(Predicate<? super Authentication> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test((Authentication)t);
    }

    default public AccessPredicate or(Predicate<? super Authentication> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test((Authentication)t);
    }

    public static AccessPredicate permitAll() {
        return AccessPredicates.PERMIT_ALL;
    }

    public static AccessPredicate authenticated() {
        return authentication -> true;
    }

    public static AccessPredicate fullyAuthenticated() {
        return authentication -> !(authentication instanceof AnonymousAuthenticationToken);
    }

    public static AccessPredicate denyAll() {
        return authentication -> false;
    }

    public static AccessPredicate hasRole(String role) {
        Objects.requireNonNull(role, "role");
        return authentication -> {
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                if (!role.equals(authority.getAuthority())) continue;
                return true;
            }
            return false;
        };
    }

    public static AccessPredicate hasAuthority(GrantedAuthority role) {
        Objects.requireNonNull(role, "role");
        return authentication -> {
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                if (!role.equals(authority)) continue;
                return true;
            }
            return false;
        };
    }

    public static AccessPredicate hasAnyRole(String ... roles) {
        Objects.requireNonNull(roles, "roles");
        return AccessPredicate.hasAnyRole(Arrays.asList(roles));
    }

    public static AccessPredicate hasAnyRole(Collection<String> roles) {
        Objects.requireNonNull(roles, "roles");
        roles.forEach(role -> Objects.requireNonNull(role, "role"));
        ImmutableSet immutableRoles = ImmutableSet.copyOf(roles);
        return arg_0 -> AccessPredicate.lambda$hasAnyRole$9((Set)immutableRoles, arg_0);
    }

    public static AccessPredicate hasAnyAuthority(GrantedAuthority ... roles) {
        Objects.requireNonNull(roles, "roles");
        return AccessPredicate.hasAnyAuthority(Arrays.asList(roles));
    }

    public static AccessPredicate hasAnyAuthority(Collection<GrantedAuthority> roles) {
        Objects.requireNonNull(roles, "roles");
        roles.forEach(role -> Objects.requireNonNull(role, "role"));
        ImmutableSet immutableRoles = ImmutableSet.copyOf(roles);
        return arg_0 -> AccessPredicate.lambda$hasAnyAuthority$11((Set)immutableRoles, arg_0);
    }

    public static AccessPredicate hasAllRoles(String ... roles) {
        Objects.requireNonNull(roles, "roles");
        return AccessPredicate.hasAnyRole(Arrays.asList(roles));
    }

    public static AccessPredicate hasAllRoles(Collection<String> roles) {
        Objects.requireNonNull(roles, "roles");
        roles.forEach(role -> Objects.requireNonNull(role, "role"));
        ImmutableSet immutableRoles = ImmutableSet.copyOf(roles);
        return arg_0 -> AccessPredicate.lambda$hasAllRoles$13((Set)immutableRoles, arg_0);
    }

    public static AccessPredicate hasAllAuthorities(GrantedAuthority ... roles) {
        Objects.requireNonNull(roles, "roles");
        return AccessPredicate.hasAllAuthorities(Arrays.asList(roles));
    }

    public static AccessPredicate hasAllAuthorities(Collection<GrantedAuthority> roles) {
        Objects.requireNonNull(roles, "roles");
        roles.forEach(role -> Objects.requireNonNull(role, "role"));
        ImmutableSet immutableRoles = ImmutableSet.copyOf(roles);
        return arg_0 -> AccessPredicate.lambda$hasAllAuthorities$15((Set)immutableRoles, arg_0);
    }

    private static /* synthetic */ boolean lambda$hasAllAuthorities$15(Set immutableRoles, Authentication authentication) {
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (immutableRoles.contains(authority)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$hasAllRoles$13(Set immutableRoles, Authentication authentication) {
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (immutableRoles.contains(authority.getAuthority())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$hasAnyAuthority$11(Set immutableRoles, Authentication authentication) {
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!immutableRoles.contains(authority)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$hasAnyRole$9(Set immutableRoles, Authentication authentication) {
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            if (!immutableRoles.contains(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }
}

