/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.EurekaClient;
import javax.annotation.PostConstruct;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaInstanceConfigBean.class, EurekaClient.class})
public class GrpcMetadataEurekaConfiguration {
    @Autowired(required=false)
    private EurekaInstanceConfig instance;
    @Autowired
    private GrpcServerProperties grpcProperties;

    @PostConstruct
    public void init() {
        if (this.instance == null) {
            return;
        }
        int port = this.grpcProperties.getPort();
        if (port != -1) {
            this.instance.getMetadataMap().put("gRPC.port", Integer.toString(port));
        }
    }
}

