/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.interceptors;

import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import java.util.Objects;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import net.devh.boot.grpc.server.security.interceptors.AbstractAuthenticatingServerCallListener;
import net.devh.boot.grpc.server.security.interceptors.AuthenticatingServerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@GrpcGlobalServerInterceptor
@Order(value=5100)
public class DefaultAuthenticatingServerInterceptor
implements AuthenticatingServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthenticatingServerInterceptor.class);
    private final AuthenticationManager authenticationManager;
    private final GrpcAuthenticationReader grpcAuthenticationReader;

    @Autowired
    public DefaultAuthenticatingServerInterceptor(AuthenticationManager authenticationManager, GrpcAuthenticationReader authenticationReader) {
        this.authenticationManager = Objects.requireNonNull(authenticationManager, "authenticationManager");
        this.grpcAuthenticationReader = Objects.requireNonNull(authenticationReader, "authenticationReader");
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Authentication authentication = this.grpcAuthenticationReader.readAuthentication(call, headers);
        if (authentication == null) {
            log.debug("No credentials found: Continuing unauthenticated");
            try {
                return next.startCall(call, headers);
            }
            catch (AccessDeniedException e) {
                throw new BadCredentialsException("No credentials found in the request", (Throwable)e);
            }
        }
        if (authentication.getDetails() == null && authentication instanceof AbstractAuthenticationToken) {
            ((AbstractAuthenticationToken)authentication).setDetails((Object)call.getAttributes());
        }
        log.debug("Credentials found: Authenticating...");
        authentication = this.authenticationManager.authenticate(authentication);
        Context context = Context.current().withValue(AUTHENTICATION_CONTEXT_KEY, (Object)authentication);
        Context previousContext = context.attach();
        SecurityContextHolder.getContext().setAuthentication(authentication);
        log.debug("Authentication successful: Continuing as {} ({})", (Object)authentication.getName(), (Object)authentication.getAuthorities());
        try {
            AuthenticatingServerCallListener authenticatingServerCallListener = new AuthenticatingServerCallListener(next.startCall(call, headers), context, authentication);
            return authenticatingServerCallListener;
        }
        catch (AccessDeniedException e) {
            if (authentication instanceof AnonymousAuthenticationToken) {
                throw new BadCredentialsException("No credentials found in the request", (Throwable)e);
            }
            throw e;
        }
        finally {
            SecurityContextHolder.clearContext();
            context.detach(previousContext);
            log.debug("startCall - Authentication cleared");
        }
    }

    private static class AuthenticatingServerCallListener<ReqT>
    extends AbstractAuthenticatingServerCallListener<ReqT> {
        private final Authentication authentication;

        public AuthenticatingServerCallListener(ServerCall.Listener<ReqT> delegate, Context context, Authentication authentication) {
            super(delegate, context);
            this.authentication = authentication;
        }

        @Override
        protected void attachAuthenticationContext() {
            SecurityContextHolder.getContext().setAuthentication(this.authentication);
        }

        @Override
        protected void detachAuthenticationContext() {
            SecurityContextHolder.clearContext();
        }

        @Override
        public void onHalfClose() {
            try {
                super.onHalfClose();
            }
            catch (AccessDeniedException e) {
                if (this.authentication instanceof AnonymousAuthenticationToken) {
                    throw new BadCredentialsException("No credentials found in the request", (Throwable)e);
                }
                throw e;
            }
        }
    }
}

