/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.devh.boot.grpc.server.config.ClientAuth;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.util.SocketUtils;

@ConfigurationProperties(value="grpc.server")
public class GrpcServerProperties {
    public static final String ANY_IP_ADDRESS = "*";
    public static final String ANY_IPv4_ADDRESS = "0.0.0.0";
    public static final String ANY_IPv6_ADDRESS = "::";
    private String address = "*";
    private int port = 9090;
    private boolean enableKeepAlive = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTime = Duration.of(60L, ChronoUnit.SECONDS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTimeout = Duration.of(20L, ChronoUnit.SECONDS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration permitKeepAliveTime = Duration.of(5L, ChronoUnit.MINUTES);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private boolean permitKeepAliveWithoutCalls = false;
    private Integer maxInboundMessageSize = null;
    private boolean healthServiceEnabled = true;
    private boolean reflectionServiceEnabled = true;
    private final Security security = new Security();

    public int getPort() {
        if (this.port == 0) {
            this.port = SocketUtils.findAvailableTcpPort();
        }
        return this.port;
    }

    public Integer getMaxInboundMessageSize() {
        if (this.maxInboundMessageSize != null && this.maxInboundMessageSize == -1) {
            this.maxInboundMessageSize = Integer.MAX_VALUE;
        }
        return this.maxInboundMessageSize;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Duration getPermitKeepAliveTime() {
        return this.permitKeepAliveTime;
    }

    public boolean isPermitKeepAliveWithoutCalls() {
        return this.permitKeepAliveWithoutCalls;
    }

    public boolean isHealthServiceEnabled() {
        return this.healthServiceEnabled;
    }

    public boolean isReflectionServiceEnabled() {
        return this.reflectionServiceEnabled;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setEnableKeepAlive(boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setPermitKeepAliveTime(Duration permitKeepAliveTime) {
        this.permitKeepAliveTime = permitKeepAliveTime;
    }

    public void setPermitKeepAliveWithoutCalls(boolean permitKeepAliveWithoutCalls) {
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
    }

    public void setMaxInboundMessageSize(Integer maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public void setHealthServiceEnabled(boolean healthServiceEnabled) {
        this.healthServiceEnabled = healthServiceEnabled;
    }

    public void setReflectionServiceEnabled(boolean reflectionServiceEnabled) {
        this.reflectionServiceEnabled = reflectionServiceEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcServerProperties)) {
            return false;
        }
        GrpcServerProperties other = (GrpcServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isEnableKeepAlive() != other.isEnableKeepAlive()) {
            return false;
        }
        Duration this$keepAliveTime = this.getKeepAliveTime();
        Duration other$keepAliveTime = other.getKeepAliveTime();
        if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
            return false;
        }
        Duration this$keepAliveTimeout = this.getKeepAliveTimeout();
        Duration other$keepAliveTimeout = other.getKeepAliveTimeout();
        if (this$keepAliveTimeout == null ? other$keepAliveTimeout != null : !((Object)this$keepAliveTimeout).equals(other$keepAliveTimeout)) {
            return false;
        }
        Duration this$permitKeepAliveTime = this.getPermitKeepAliveTime();
        Duration other$permitKeepAliveTime = other.getPermitKeepAliveTime();
        if (this$permitKeepAliveTime == null ? other$permitKeepAliveTime != null : !((Object)this$permitKeepAliveTime).equals(other$permitKeepAliveTime)) {
            return false;
        }
        if (this.isPermitKeepAliveWithoutCalls() != other.isPermitKeepAliveWithoutCalls()) {
            return false;
        }
        Integer this$maxInboundMessageSize = this.getMaxInboundMessageSize();
        Integer other$maxInboundMessageSize = other.getMaxInboundMessageSize();
        if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !((Object)this$maxInboundMessageSize).equals(other$maxInboundMessageSize)) {
            return false;
        }
        if (this.isHealthServiceEnabled() != other.isHealthServiceEnabled()) {
            return false;
        }
        if (this.isReflectionServiceEnabled() != other.isReflectionServiceEnabled()) {
            return false;
        }
        Security this$security = this.getSecurity();
        Security other$security = other.getSecurity();
        return !(this$security == null ? other$security != null : !((Object)this$security).equals(other$security));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isEnableKeepAlive() ? 79 : 97);
        Duration $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
        Duration $keepAliveTimeout = this.getKeepAliveTimeout();
        result = result * 59 + ($keepAliveTimeout == null ? 43 : ((Object)$keepAliveTimeout).hashCode());
        Duration $permitKeepAliveTime = this.getPermitKeepAliveTime();
        result = result * 59 + ($permitKeepAliveTime == null ? 43 : ((Object)$permitKeepAliveTime).hashCode());
        result = result * 59 + (this.isPermitKeepAliveWithoutCalls() ? 79 : 97);
        Integer $maxInboundMessageSize = this.getMaxInboundMessageSize();
        result = result * 59 + ($maxInboundMessageSize == null ? 43 : ((Object)$maxInboundMessageSize).hashCode());
        result = result * 59 + (this.isHealthServiceEnabled() ? 79 : 97);
        result = result * 59 + (this.isReflectionServiceEnabled() ? 79 : 97);
        Security $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        return result;
    }

    public String toString() {
        return "GrpcServerProperties(address=" + this.getAddress() + ", port=" + this.getPort() + ", enableKeepAlive=" + this.isEnableKeepAlive() + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", permitKeepAliveTime=" + this.getPermitKeepAliveTime() + ", permitKeepAliveWithoutCalls=" + this.isPermitKeepAliveWithoutCalls() + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", healthServiceEnabled=" + this.isHealthServiceEnabled() + ", reflectionServiceEnabled=" + this.isReflectionServiceEnabled() + ", security=" + this.getSecurity() + ")";
    }

    public static class Security {
        private boolean enabled = false;
        private String certificateChainPath = null;
        private String privateKeyPath = null;
        private ClientAuth clientAuth = ClientAuth.NONE;
        private String trustCertCollectionPath = null;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getCertificateChainPath() {
            return this.certificateChainPath;
        }

        public String getPrivateKeyPath() {
            return this.privateKeyPath;
        }

        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public String getTrustCertCollectionPath() {
            return this.trustCertCollectionPath;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setCertificateChainPath(String certificateChainPath) {
            this.certificateChainPath = certificateChainPath;
        }

        public void setPrivateKeyPath(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
        }

        public void setClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }

        public void setTrustCertCollectionPath(String trustCertCollectionPath) {
            this.trustCertCollectionPath = trustCertCollectionPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Security)) {
                return false;
            }
            Security other = (Security)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$certificateChainPath = this.getCertificateChainPath();
            String other$certificateChainPath = other.getCertificateChainPath();
            if (this$certificateChainPath == null ? other$certificateChainPath != null : !this$certificateChainPath.equals(other$certificateChainPath)) {
                return false;
            }
            String this$privateKeyPath = this.getPrivateKeyPath();
            String other$privateKeyPath = other.getPrivateKeyPath();
            if (this$privateKeyPath == null ? other$privateKeyPath != null : !this$privateKeyPath.equals(other$privateKeyPath)) {
                return false;
            }
            ClientAuth this$clientAuth = this.getClientAuth();
            ClientAuth other$clientAuth = other.getClientAuth();
            if (this$clientAuth == null ? other$clientAuth != null : !((Object)((Object)this$clientAuth)).equals((Object)other$clientAuth)) {
                return false;
            }
            String this$trustCertCollectionPath = this.getTrustCertCollectionPath();
            String other$trustCertCollectionPath = other.getTrustCertCollectionPath();
            return !(this$trustCertCollectionPath == null ? other$trustCertCollectionPath != null : !this$trustCertCollectionPath.equals(other$trustCertCollectionPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Security;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $certificateChainPath = this.getCertificateChainPath();
            result = result * 59 + ($certificateChainPath == null ? 43 : $certificateChainPath.hashCode());
            String $privateKeyPath = this.getPrivateKeyPath();
            result = result * 59 + ($privateKeyPath == null ? 43 : $privateKeyPath.hashCode());
            ClientAuth $clientAuth = this.getClientAuth();
            result = result * 59 + ($clientAuth == null ? 43 : ((Object)((Object)$clientAuth)).hashCode());
            String $trustCertCollectionPath = this.getTrustCertCollectionPath();
            result = result * 59 + ($trustCertCollectionPath == null ? 43 : $trustCertCollectionPath.hashCode());
            return result;
        }

        public String toString() {
            return "GrpcServerProperties.Security(enabled=" + this.isEnabled() + ", certificateChainPath=" + this.getCertificateChainPath() + ", privateKeyPath=" + this.getPrivateKeyPath() + ", clientAuth=" + (Object)((Object)this.getClientAuth()) + ", trustCertCollectionPath=" + this.getTrustCertCollectionPath() + ")";
        }
    }
}

