/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.check;

import io.grpc.ServerCall;
import java.util.Collection;
import net.devh.boot.grpc.server.security.check.AccessPredicateConfigAttribute;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class AccessPredicateVoter
implements AccessDecisionVoter<ServerCall<?, ?>> {
    public boolean supports(ConfigAttribute attribute) {
        return attribute instanceof AccessPredicateConfigAttribute;
    }

    public boolean supports(Class<?> clazz) {
        return ServerCall.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, ServerCall<?, ?> serverCall, Collection<ConfigAttribute> attributes) {
        AccessPredicateConfigAttribute attr = this.find(attributes);
        if (attr == null) {
            return 0;
        }
        boolean allowed = attr.getAccessPredicate().test(authentication, serverCall);
        return allowed ? 1 : -1;
    }

    private AccessPredicateConfigAttribute find(Collection<ConfigAttribute> attributes) {
        for (ConfigAttribute attribute : attributes) {
            if (!(attribute instanceof AccessPredicateConfigAttribute)) continue;
            return (AccessPredicateConfigAttribute)attribute;
        }
        return null;
    }
}

