/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import io.grpc.BindableService;
import io.grpc.services.HealthStatusManager;
import net.devh.boot.grpc.server.autoconfigure.GrpcServerFactoryAutoConfiguration;
import net.devh.boot.grpc.server.service.GrpcService;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HealthStatusManager.class})
@ConditionalOnProperty(prefix="grpc.server", name={"health-service-enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={GrpcServerFactoryAutoConfiguration.class})
public class GrpcHealthServiceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    HealthStatusManager healthStatusManager() {
        return new HealthStatusManager();
    }

    @Bean
    @GrpcService
    BindableService grpcHealthService(HealthStatusManager healthStatusManager) {
        return healthStatusManager.getHealthService();
    }
}

