/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.advice;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import net.devh.boot.grpc.server.advice.GrpcAdviceExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcAdviceExceptionListener<ReqT, RespT>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
    private static final Logger log = LoggerFactory.getLogger(GrpcAdviceExceptionListener.class);
    private final GrpcAdviceExceptionHandler exceptionHandler;
    private final ServerCall<ReqT, RespT> serverCall;

    protected GrpcAdviceExceptionListener(ServerCall.Listener<ReqT> delegate, ServerCall<ReqT, RespT> serverCall, GrpcAdviceExceptionHandler grpcAdviceExceptionHandler) {
        super(delegate);
        this.serverCall = serverCall;
        this.exceptionHandler = grpcAdviceExceptionHandler;
    }

    public void onHalfClose() {
        try {
            super.onHalfClose();
        }
        catch (Throwable throwable) {
            this.handleCaughtException(throwable);
        }
    }

    private void handleCaughtException(Throwable throwable) {
        try {
            Object mappedReturnType = this.exceptionHandler.handleThrownException(throwable);
            Status status = this.resolveStatus(mappedReturnType).withCause(throwable);
            Metadata metadata = this.resolveMetadata(mappedReturnType);
            this.serverCall.close(status, metadata);
        }
        catch (Throwable throwableWhileResolving) {
            this.handleThrownExceptionByImplementation(throwableWhileResolving);
        }
    }

    private Status resolveStatus(Object mappedReturnType) {
        if (mappedReturnType instanceof Status) {
            return (Status)mappedReturnType;
        }
        if (mappedReturnType instanceof Throwable) {
            return Status.fromThrowable((Throwable)((Throwable)mappedReturnType));
        }
        throw new IllegalStateException(String.format("Error for mapped return type [%s] inside @GrpcAdvice, it has to be of type: [Status, StatusException, StatusRuntimeException, Throwable] ", mappedReturnType));
    }

    private Metadata resolveMetadata(Object mappedReturnType) {
        Metadata result = null;
        if (mappedReturnType instanceof StatusException) {
            StatusException statusException = (StatusException)mappedReturnType;
            result = statusException.getTrailers();
        } else if (mappedReturnType instanceof StatusRuntimeException) {
            StatusRuntimeException statusException = (StatusRuntimeException)mappedReturnType;
            result = statusException.getTrailers();
        }
        return result == null ? new Metadata() : result;
    }

    private void handleThrownExceptionByImplementation(Throwable throwable) {
        log.error("Exception thrown during invocation of annotated @GrpcExceptionHandler method: ", throwable);
        this.serverCall.close(Status.INTERNAL.withCause(throwable).withDescription("There was a server error trying to handle an exception"), new Metadata());
    }
}

