/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.serverfactory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.reflection.v1alpha.ServerReflectionGrpc;
import io.grpc.services.HealthStatusManager;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;
import net.devh.boot.grpc.server.serverfactory.GrpcServerFactory;
import net.devh.boot.grpc.server.service.GrpcServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.unit.DataSize;

public abstract class AbstractGrpcServerFactory<T extends ServerBuilder<T>>
implements GrpcServerFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractGrpcServerFactory.class);
    private final List<GrpcServiceDefinition> serviceList = Lists.newLinkedList();
    protected final GrpcServerProperties properties;
    protected final List<GrpcServerConfigurer> serverConfigurers;
    @Autowired
    @VisibleForTesting
    HealthStatusManager healthStatusManager;

    public AbstractGrpcServerFactory(GrpcServerProperties properties, List<GrpcServerConfigurer> serverConfigurers) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.serverConfigurers = Objects.requireNonNull(serverConfigurers, "serverConfigurers");
    }

    @Override
    public Server createServer() {
        T builder = this.newServerBuilder();
        this.configure(builder);
        return builder.build();
    }

    protected abstract T newServerBuilder();

    protected void configure(T builder) {
        this.configureServices(builder);
        this.configureKeepAlive(builder);
        this.configureSecurity(builder);
        this.configureLimits(builder);
        for (GrpcServerConfigurer serverConfigurer : this.serverConfigurers) {
            serverConfigurer.accept(builder);
        }
    }

    protected void configureServices(T builder) {
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        if (this.properties.isHealthServiceEnabled()) {
            builder.addService(this.healthStatusManager.getHealthService());
            serviceNames.add(HealthGrpc.getServiceDescriptor().getName());
        }
        if (this.properties.isReflectionServiceEnabled()) {
            builder.addService(ProtoReflectionService.newInstance());
            serviceNames.add(ServerReflectionGrpc.getServiceDescriptor().getName());
        }
        for (GrpcServiceDefinition service : this.serviceList) {
            String serviceName = service.getDefinition().getServiceDescriptor().getName();
            if (!serviceNames.add(serviceName)) {
                throw new IllegalStateException("Found duplicate service implementation: " + serviceName);
            }
            log.info("Registered gRPC service: " + serviceName + ", bean: " + service.getBeanName() + ", class: " + service.getBeanClazz().getName());
            builder.addService(service.getDefinition());
            this.healthStatusManager.setStatus(serviceName, HealthCheckResponse.ServingStatus.SERVING);
        }
    }

    protected void configureKeepAlive(T builder) {
        if (this.properties.isEnableKeepAlive()) {
            throw new IllegalStateException("KeepAlive is enabled but this implementation does not support keepAlive!");
        }
    }

    protected void configureSecurity(T builder) {
        if (this.properties.getSecurity().isEnabled()) {
            throw new IllegalStateException("Security is enabled but this implementation does not support security!");
        }
    }

    protected void configureLimits(T builder) {
        DataSize maxInboundMetadataSize;
        DataSize maxInboundMessageSize = this.properties.getMaxInboundMessageSize();
        if (maxInboundMessageSize != null) {
            builder.maxInboundMessageSize((int)maxInboundMessageSize.toBytes());
        }
        if ((maxInboundMetadataSize = this.properties.getMaxInboundMetadataSize()) != null) {
            builder.maxInboundMetadataSize((int)maxInboundMetadataSize.toBytes());
        }
    }

    @Override
    public String getAddress() {
        return this.properties.getAddress();
    }

    @Override
    public int getPort() {
        return this.properties.getPort();
    }

    @Override
    public void addService(GrpcServiceDefinition service) {
        this.serviceList.add(service);
    }

    @Override
    public void destroy() {
        for (GrpcServiceDefinition grpcServiceDefinition : this.serviceList) {
            String serviceName = grpcServiceDefinition.getDefinition().getServiceDescriptor().getName();
            this.healthStatusManager.clearStatus(serviceName);
        }
    }
}

