/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.interceptors;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import net.devh.boot.grpc.server.interceptor.GrpcGlobalServerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;

@GrpcGlobalServerInterceptor
@Order(value=5000)
public class ExceptionTranslatingServerInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ExceptionTranslatingServerInterceptor.class);
    public static final String UNAUTHENTICATED_DESCRIPTION = "Authentication failed";
    public static final String ACCESS_DENIED_DESCRIPTION = "Access denied";

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        try {
            return new ExceptionTranslatorServerCallListener<ReqT, RespT>(next.startCall(call, headers), call);
        }
        catch (AuthenticationException aex) {
            this.closeCallUnauthenticated(call, aex);
            return this.noOpCallListener();
        }
        catch (AccessDeniedException aex) {
            this.closeCallAccessDenied(call, aex);
            return this.noOpCallListener();
        }
    }

    protected <ReqT> ServerCall.Listener<ReqT> noOpCallListener() {
        return new ServerCall.Listener<ReqT>(){};
    }

    protected void closeCallUnauthenticated(ServerCall<?, ?> call, AuthenticationException aex) {
        log.debug(UNAUTHENTICATED_DESCRIPTION, (Throwable)aex);
        call.close(Status.UNAUTHENTICATED.withCause((Throwable)aex).withDescription(UNAUTHENTICATED_DESCRIPTION), new Metadata());
    }

    protected void closeCallAccessDenied(ServerCall<?, ?> call, AccessDeniedException aex) {
        log.debug(ACCESS_DENIED_DESCRIPTION, (Throwable)aex);
        call.close(Status.PERMISSION_DENIED.withCause((Throwable)aex).withDescription(ACCESS_DENIED_DESCRIPTION), new Metadata());
    }

    private class ExceptionTranslatorServerCallListener<ReqT, RespT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        private final ServerCall<ReqT, RespT> call;

        protected ExceptionTranslatorServerCallListener(ServerCall.Listener<ReqT> delegate, ServerCall<ReqT, RespT> call) {
            super(delegate);
            this.call = call;
        }

        public void onHalfClose() {
            try {
                super.onHalfClose();
            }
            catch (AuthenticationException aex) {
                ExceptionTranslatingServerInterceptor.this.closeCallUnauthenticated(this.call, aex);
            }
            catch (AccessDeniedException aex) {
                ExceptionTranslatingServerInterceptor.this.closeCallAccessDenied(this.call, aex);
            }
        }
    }
}

