/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.advice;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Map;
import net.devh.boot.grpc.server.advice.GrpcExceptionHandlerMethodResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class GrpcAdviceExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GrpcAdviceExceptionHandler.class);
    private final GrpcExceptionHandlerMethodResolver grpcExceptionHandlerMethodResolver;

    public GrpcAdviceExceptionHandler(GrpcExceptionHandlerMethodResolver grpcExceptionHandlerMethodResolver) {
        this.grpcExceptionHandlerMethodResolver = grpcExceptionHandlerMethodResolver;
    }

    @Nullable
    public <E extends Throwable> Object handleThrownException(E exception) throws Throwable {
        log.debug("Exception caught during gRPC execution: ", exception);
        Class<?> exceptionClass = exception.getClass();
        boolean exceptionIsMapped = this.grpcExceptionHandlerMethodResolver.isMethodMappedForException(exceptionClass);
        if (!exceptionIsMapped) {
            throw exception;
        }
        Map.Entry<Object, Method> methodWithInstance = this.grpcExceptionHandlerMethodResolver.resolveMethodWithInstance(exceptionClass);
        Method mappedMethod = methodWithInstance.getValue();
        Object instanceOfMappedMethod = methodWithInstance.getKey();
        Object[] instancedParams = this.determineInstancedParameters(mappedMethod, exception);
        return this.invokeMappedMethodSafely(mappedMethod, instanceOfMappedMethod, instancedParams);
    }

    private <E extends Throwable> Object[] determineInstancedParameters(Method mappedMethod, E exception) {
        Parameter[] parameters = mappedMethod.getParameters();
        Object[] instancedParams = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> parameterClass = this.convertToClass(parameters[i]);
            if (!parameterClass.isAssignableFrom(exception.getClass())) continue;
            instancedParams[i] = exception;
            break;
        }
        return instancedParams;
    }

    private Class<?> convertToClass(Parameter parameter) {
        Type paramType = parameter.getParameterizedType();
        if (paramType instanceof Class) {
            return (Class)paramType;
        }
        throw new IllegalStateException("Parameter type of method has to be from Class, it was: " + paramType);
    }

    private Object invokeMappedMethodSafely(Method mappedMethod, Object instanceOfMappedMethod, Object[] instancedParams) throws Throwable {
        try {
            return mappedMethod.invoke(instanceOfMappedMethod, instancedParams);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

