/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Server;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.services.HealthStatusManager;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerFactory;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerProperties;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDefinition;
import net.devh.springboot.autoconfigure.grpc.server.codec.CodecType;
import net.devh.springboot.autoconfigure.grpc.server.codec.GrpcCodecDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NettyGrpcServerFactory
implements GrpcServerFactory {
    private static final Logger log = LoggerFactory.getLogger(NettyGrpcServerFactory.class);
    private final GrpcServerProperties properties;
    private final List<GrpcServiceDefinition> serviceList = Lists.newLinkedList();
    private final List<GrpcCodecDefinition> codecList = Lists.newLinkedList();
    @Autowired
    private HealthStatusManager healthStatusManager;

    public NettyGrpcServerFactory(GrpcServerProperties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    @Override
    public Server createServer() {
        NettyServerBuilder builder = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(InetAddresses.forString((String)this.getAddress()), this.getPort()));
        this.configure(builder);
        return builder.build();
    }

    protected void configure(NettyServerBuilder builder) {
        this.configureServices(builder);
        this.configureSecurity(builder);
        this.configureLimits(builder);
        this.configureCodecs(builder);
    }

    protected void configureServices(NettyServerBuilder builder) {
        if (this.properties.isHealthServiceEnabled()) {
            builder.addService(this.healthStatusManager.getHealthService());
        }
        if (this.properties.isReflectionServiceEnabled()) {
            builder.addService(ProtoReflectionService.newInstance());
        }
        for (GrpcServiceDefinition service : this.serviceList) {
            String serviceName = service.getDefinition().getServiceDescriptor().getName();
            log.info("Registered gRPC service: " + serviceName + ", bean: " + service.getBeanName() + ", class: " + service.getBeanClazz().getName());
            builder.addService(service.getDefinition());
            this.healthStatusManager.setStatus(serviceName, HealthCheckResponse.ServingStatus.SERVING);
        }
    }

    protected void configureSecurity(NettyServerBuilder builder) {
        GrpcServerProperties.Security security = this.properties.getSecurity();
        if (security.isEnabled()) {
            File certificateChainFile = this.toCheckedFile("certificateChain", security.getCertificateChainPath());
            File privateKeyFile = this.toCheckedFile("privateKey", security.getPrivateKeyPath());
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forServer((File)certificateChainFile, (File)privateKeyFile);
            if (security.getClientAuth() != ClientAuth.NONE) {
                sslContextBuilder.clientAuth(security.getClientAuth());
                String trustCertCollectionPath = security.getTrustCertCollectionPath();
                if (trustCertCollectionPath != null && !trustCertCollectionPath.isEmpty()) {
                    File trustCertCollectionFile = this.toCheckedFile("trustCertCollection", trustCertCollectionPath);
                    sslContextBuilder.trustManager(trustCertCollectionFile);
                }
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc server", e);
            }
        }
    }

    private File toCheckedFile(String context, String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException(context + " path cannot be null or blank");
        }
        File file = new File(path);
        if (!file.isFile()) {
            String message = context + " file does not exist or path does not refer to a file: '" + file.getPath() + "'";
            if (!file.isAbsolute()) {
                message = message + " (" + file.getAbsolutePath() + ")";
            }
            throw new IllegalArgumentException(message);
        }
        return file;
    }

    protected void configureLimits(NettyServerBuilder builder) {
        Integer maxInboundMessageSize = this.properties.getMaxInboundMessageSize();
        if (maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(maxInboundMessageSize.intValue());
        }
    }

    protected void configureCodecs(NettyServerBuilder builder) {
        if (this.codecList.isEmpty()) {
            CompressorRegistry compressorRegistry = CompressorRegistry.newEmptyInstance();
            DecompressorRegistry decompressorRegistry = DecompressorRegistry.emptyInstance();
            for (GrpcCodecDefinition grpcCodecDefinition : this.codecList) {
                if (grpcCodecDefinition.getCodecType().equals((Object)CodecType.COMPRESS)) {
                    compressorRegistry.register((Compressor)grpcCodecDefinition.getCodec());
                    continue;
                }
                if (grpcCodecDefinition.getCodecType().equals((Object)CodecType.DECOMPRESS)) {
                    decompressorRegistry.with((Decompressor)grpcCodecDefinition.getCodec(), grpcCodecDefinition.isAdvertised());
                    continue;
                }
                compressorRegistry.register((Compressor)grpcCodecDefinition.getCodec());
                decompressorRegistry.with((Decompressor)grpcCodecDefinition.getCodec(), grpcCodecDefinition.isAdvertised());
            }
            builder.compressorRegistry(compressorRegistry);
            builder.decompressorRegistry(decompressorRegistry);
        }
    }

    @Override
    public String getAddress() {
        return this.properties.getAddress();
    }

    @Override
    public int getPort() {
        return this.properties.getPort();
    }

    @Override
    public void addService(GrpcServiceDefinition service) {
        this.serviceList.add(service);
    }

    @Override
    public void addCodec(GrpcCodecDefinition codec) {
        this.codecList.add(codec);
    }

    @Override
    public void destroy() {
        for (GrpcServiceDefinition grpcServiceDefinition : this.serviceList) {
            String serviceName = grpcServiceDefinition.getDefinition().getServiceDescriptor().getName();
            this.healthStatusManager.clearStatus(serviceName);
        }
    }
}

