/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import io.grpc.Server;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.services.HealthStatusManager;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerFactory;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerProperties;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NettyGrpcServerFactory
implements GrpcServerFactory {
    private static final Logger log = LoggerFactory.getLogger(NettyGrpcServerFactory.class);
    private final GrpcServerProperties properties;
    private final List<GrpcServiceDefinition> services = Lists.newLinkedList();
    @Autowired
    private HealthStatusManager healthStatusManager;

    public NettyGrpcServerFactory(GrpcServerProperties properties) {
        this.properties = properties;
    }

    @Override
    public Server createServer() {
        NettyServerBuilder builder = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(InetAddresses.forString((String)this.getAddress()), this.getPort()));
        builder.addService(this.healthStatusManager.getHealthService());
        for (GrpcServiceDefinition service : this.services) {
            String serviceName = service.getDefinition().getServiceDescriptor().getName();
            log.info("Registered gRPC service: " + serviceName + ", bean: " + service.getBeanName() + ", class: " + service.getBeanClazz().getName());
            builder.addService(service.getDefinition());
            this.healthStatusManager.setStatus(serviceName, HealthCheckResponse.ServingStatus.SERVING);
        }
        if (this.properties.getSecurity().getEnabled().booleanValue()) {
            File certificateChain = new File(this.properties.getSecurity().getCertificateChainPath());
            File certificate = new File(this.properties.getSecurity().getCertificatePath());
            builder.useTransportSecurity(certificateChain, certificate);
        }
        if (this.properties.getMaxMessageSize() > 0) {
            builder.maxMessageSize(this.properties.getMaxMessageSize());
        }
        return builder.build();
    }

    @Override
    public String getAddress() {
        return this.properties.getAddress();
    }

    @Override
    public int getPort() {
        return this.properties.getPort();
    }

    @Override
    public void addService(GrpcServiceDefinition service) {
        this.services.add(service);
    }

    @Override
    public void destroy() {
        for (GrpcServiceDefinition grpcServiceDefinition : this.services) {
            String serviceName = grpcServiceDefinition.getDefinition().getServiceDescriptor().getName();
            this.healthStatusManager.clearStatus(serviceName);
        }
    }
}

