/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import io.grpc.Server;
import io.netty.channel.Channel;
import net.devh.springboot.autoconfigure.grpc.server.AnnotationGrpcServiceDiscoverer;
import net.devh.springboot.autoconfigure.grpc.server.GlobalServerInterceptorConfigurerAdapter;
import net.devh.springboot.autoconfigure.grpc.server.GlobalServerInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerFactory;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerLifecycle;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerProperties;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDefinition;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDiscoverer;
import net.devh.springboot.autoconfigure.grpc.server.MetadataExtractor;
import net.devh.springboot.autoconfigure.grpc.server.NettyGrpcServerFactory;
import net.devh.springboot.autoconfigure.grpc.server.TraceServerInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={Server.class, GrpcServerFactory.class})
public class GrpcServerAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public GrpcServerProperties defaultGrpcServerProperties() {
        return new GrpcServerProperties();
    }

    @Bean
    public GlobalServerInterceptorRegistry globalServerInterceptorRegistry() {
        return new GlobalServerInterceptorRegistry();
    }

    @ConditionalOnMissingBean
    @Bean
    public AnnotationGrpcServiceDiscoverer defaultGrpcServiceFinder() {
        return new AnnotationGrpcServiceDiscoverer();
    }

    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Channel.class})
    @Bean
    public NettyGrpcServerFactory nettyGrpcServiceFactory(GrpcServerProperties properties, GrpcServiceDiscoverer discoverer) {
        NettyGrpcServerFactory factory = new NettyGrpcServerFactory(properties);
        for (GrpcServiceDefinition service : discoverer.findGrpcServices()) {
            factory.addService(service);
        }
        return factory;
    }

    @ConditionalOnMissingBean
    @Bean
    public GrpcServerLifecycle grpcServerLifecycle(GrpcServerFactory factory) {
        return new GrpcServerLifecycle(factory);
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.sleuth.scheduled.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={Tracer.class})
    protected static class TraceServerAutoConfiguration {
        protected TraceServerAutoConfiguration() {
        }

        @Bean
        public GlobalServerInterceptorConfigurerAdapter globalTraceServerInterceptorConfigurerAdapter(final Tracer tracer) {
            return new GlobalServerInterceptorConfigurerAdapter(){

                @Override
                public void addServerInterceptors(GlobalServerInterceptorRegistry registry) {
                    registry.addServerInterceptors(new TraceServerInterceptor(tracer, new MetadataExtractor()));
                }
            };
        }
    }
}

