/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.interceptor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.grpc.ClientInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class GlobalClientInterceptorRegistry
implements ApplicationContextAware {
    private final List<ClientInterceptor> clientInterceptors = Lists.newArrayList();
    private ImmutableList<ClientInterceptor> sortedClientInterceptors;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map map = this.applicationContext.getBeansOfType(GlobalClientInterceptorConfigurer.class);
        for (GlobalClientInterceptorConfigurer globalClientInterceptorConfigurer : map.values()) {
            globalClientInterceptorConfigurer.addClientInterceptors(this);
        }
    }

    public GlobalClientInterceptorRegistry addClientInterceptors(ClientInterceptor interceptor) {
        this.sortedClientInterceptors = null;
        this.clientInterceptors.add(interceptor);
        return this;
    }

    public ImmutableList<ClientInterceptor> getClientInterceptors() {
        if (this.sortedClientInterceptors == null) {
            ArrayList temp = Lists.newArrayList(this.clientInterceptors);
            this.sortInterceptors(temp);
            this.sortedClientInterceptors = ImmutableList.copyOf((Collection)temp);
        }
        return this.sortedClientInterceptors;
    }

    public void sortInterceptors(List<? extends ClientInterceptor> interceptors) {
        interceptors.sort((Comparator<? extends ClientInterceptor>)AnnotationAwareOrderComparator.INSTANCE);
    }
}

