/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import io.grpc.NameResolver;
import io.grpc.NameResolverRegistry;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMappedNameResolverFactory
extends NameResolver.Factory {
    private static final Logger log = LoggerFactory.getLogger(ConfigMappedNameResolverFactory.class);
    private final GrpcChannelsProperties config;
    private final NameResolver.Factory delegate;

    public ConfigMappedNameResolverFactory(GrpcChannelsProperties config) {
        this(config, NameResolverRegistry.getDefaultRegistry());
    }

    public ConfigMappedNameResolverFactory(GrpcChannelsProperties config, NameResolverRegistry registry) {
        this(config, registry.asFactory());
    }

    public ConfigMappedNameResolverFactory(GrpcChannelsProperties config, NameResolver.Factory delegate) {
        this.config = Objects.requireNonNull(config, "config");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        String clientName = targetUri.toString();
        GrpcChannelProperties clientConfig = this.config.getChannel(clientName);
        URI remappedUri = clientConfig.getAddress();
        if (remappedUri == null) {
            remappedUri = URI.create(clientName);
        }
        log.debug("Remapping target URI for {} to {} via {}", new Object[]{clientName, remappedUri, this.delegate});
        NameResolver resolver = this.delegate.newNameResolver(remappedUri, args);
        if (resolver != null) {
            return resolver;
        }
        remappedUri = URI.create(this.getDefaultSchemeInternal() + ":/" + remappedUri.toString());
        log.debug("Remapping target URI (with default scheme) for {} to {} via {}", new Object[]{clientName, remappedUri, this.delegate});
        return this.delegate.newNameResolver(remappedUri, args);
    }

    public String getDefaultScheme() {
        return "";
    }

    private String getDefaultSchemeInternal() {
        String configured = this.config.getDefaultScheme();
        if (configured != null) {
            return configured;
        }
        return this.delegate.getDefaultScheme();
    }

    public String toString() {
        return "ConfigMappedNameResolverFactory [config=" + this.config + ", delegate=" + this.delegate + "]";
    }
}

