/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.autoconfigure;

import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import java.util.Collections;
import java.util.List;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelConfigurer;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelFactory;
import net.devh.boot.grpc.client.channelfactory.InProcessChannelFactory;
import net.devh.boot.grpc.client.channelfactory.InProcessOrAlternativeChannelFactory;
import net.devh.boot.grpc.client.channelfactory.NettyChannelFactory;
import net.devh.boot.grpc.client.channelfactory.ShadedNettyChannelFactory;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.inject.GrpcClientBeanPostProcessor;
import net.devh.boot.grpc.client.interceptor.AnnotationGlobalClientInterceptorConfigurer;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorRegistry;
import net.devh.boot.grpc.client.nameresolver.ConfigMappedNameResolverFactory;
import net.devh.boot.grpc.client.nameresolver.NameResolverRegistration;
import net.devh.boot.grpc.common.autoconfigure.GrpcCommonCodecAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties
@AutoConfigureAfter(name={"org.springframework.cloud.client.CommonsClientAutoConfiguration"}, value={GrpcCommonCodecAutoConfiguration.class})
public class GrpcClientAutoConfiguration {
    @Bean
    public static GrpcClientBeanPostProcessor grpcClientBeanPostProcessor(ApplicationContext applicationContext) {
        return new GrpcClientBeanPostProcessor(applicationContext);
    }

    @ConditionalOnMissingBean
    @Bean
    public GrpcChannelsProperties grpcChannelsProperties() {
        return new GrpcChannelsProperties();
    }

    @ConditionalOnMissingBean
    @Bean
    public GlobalClientInterceptorRegistry globalClientInterceptorRegistry() {
        return new GlobalClientInterceptorRegistry();
    }

    @Bean
    public AnnotationGlobalClientInterceptorConfigurer annotationGlobalClientInterceptorConfigurer() {
        return new AnnotationGlobalClientInterceptorConfigurer();
    }

    @ConditionalOnMissingBean
    @Lazy
    @Bean
    public NameResolverRegistration grpcNameResolverRegistration(@Autowired(required=false) List<NameResolverProvider> nameResolverProviders) {
        return new NameResolverRegistration(nameResolverProviders);
    }

    @ConditionalOnMissingBean
    @Lazy
    @Bean
    public NameResolverRegistry grpcNameResolverRegistry(NameResolverRegistration registration) {
        NameResolverRegistry registry = NameResolverRegistry.getDefaultRegistry();
        registration.register(registry);
        return registry;
    }

    @ConditionalOnMissingBean(name={"grpcNameResolverFactory"})
    @Lazy
    @Bean
    @Primary
    public NameResolver.Factory grpcNameResolverFactory(GrpcChannelsProperties channelProperties, NameResolverRegistry registry) {
        return new ConfigMappedNameResolverFactory(channelProperties, registry);
    }

    @ConditionalOnBean(value={CompressorRegistry.class})
    @Bean
    public GrpcChannelConfigurer compressionChannelConfigurer(CompressorRegistry registry) {
        return (builder, name) -> builder.compressorRegistry(registry);
    }

    @ConditionalOnBean(value={DecompressorRegistry.class})
    @Bean
    public GrpcChannelConfigurer decompressionChannelConfigurer(DecompressorRegistry registry) {
        return (builder, name) -> builder.decompressorRegistry(registry);
    }

    @ConditionalOnMissingBean(value={GrpcChannelConfigurer.class})
    @Bean
    public List<GrpcChannelConfigurer> defaultChannelConfigurers() {
        return Collections.emptyList();
    }

    @ConditionalOnMissingBean(value={GrpcChannelFactory.class})
    @ConditionalOnClass(name={"io.grpc.netty.shaded.io.netty.channel.Channel", "io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder"})
    @Bean
    public GrpcChannelFactory shadedNettyGrpcChannelFactory(GrpcChannelsProperties properties, NameResolver.Factory nameResolverFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        ShadedNettyChannelFactory channelFactory = new ShadedNettyChannelFactory(properties, nameResolverFactory, globalClientInterceptorRegistry, channelConfigurers);
        InProcessChannelFactory inProcessChannelFactory = new InProcessChannelFactory(properties, globalClientInterceptorRegistry, channelConfigurers);
        return new InProcessOrAlternativeChannelFactory(properties, inProcessChannelFactory, channelFactory);
    }

    @ConditionalOnMissingBean(value={GrpcChannelFactory.class})
    @ConditionalOnClass(name={"io.netty.channel.Channel", "io.grpc.netty.NettyChannelBuilder"})
    @Bean
    public GrpcChannelFactory nettyGrpcChannelFactory(GrpcChannelsProperties properties, NameResolver.Factory nameResolverFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        NettyChannelFactory channelFactory = new NettyChannelFactory(properties, nameResolverFactory, globalClientInterceptorRegistry, channelConfigurers);
        InProcessChannelFactory inProcessChannelFactory = new InProcessChannelFactory(properties, globalClientInterceptorRegistry, channelConfigurers);
        return new InProcessOrAlternativeChannelFactory(properties, inProcessChannelFactory, channelFactory);
    }

    @ConditionalOnMissingBean(value={GrpcChannelFactory.class})
    @Bean
    public GrpcChannelFactory inProcessGrpcChannelFactory(GrpcChannelsProperties properties, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        return new InProcessChannelFactory(properties, globalClientInterceptorRegistry, channelConfigurers);
    }
}

