/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.security;

import io.grpc.CallCredentials;
import io.grpc.CallCredentials2;
import io.grpc.Metadata;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.devh.boot.grpc.client.inject.StubTransformer;
import net.devh.boot.grpc.common.security.SecurityConstants;

public class CallCredentialsHelper {
    public static StubTransformer fixedCredentialsStubTransformer(CallCredentials credentials) {
        Objects.requireNonNull(credentials, "credentials");
        return (name, stub) -> stub.withCallCredentials(credentials);
    }

    public static StubTransformer mappedCredentialsStubTransformer(Map<String, CallCredentials> credentialsByName) {
        return CallCredentialsHelper.mappedCredentialsStubTransformer(credentialsByName, null);
    }

    public static StubTransformer mappedCredentialsStubTransformer(Map<String, CallCredentials> credentialsByName, @Nullable CallCredentials fallback) {
        Objects.requireNonNull(credentialsByName, "credentials");
        return (name, stub) -> {
            CallCredentials credentials = credentialsByName.getOrDefault(name, fallback);
            if (credentials == null) {
                return stub;
            }
            return stub.withCallCredentials(credentials);
        };
    }

    public static CallCredentials2 bearerAuth(String token) {
        Metadata extraHeaders = new Metadata();
        extraHeaders.put(SecurityConstants.AUTHORIZATION_HEADER, (Object)("Bearer " + token));
        return new StaticSecurityHeaderCallCredentials(extraHeaders);
    }

    public static CallCredentials2 basicAuth(String username, String password) {
        Metadata extraHeaders = new Metadata();
        extraHeaders.put(SecurityConstants.AUTHORIZATION_HEADER, (Object)CallCredentialsHelper.encodeBasicAuth(username, password));
        return new StaticSecurityHeaderCallCredentials(extraHeaders);
    }

    public static String encodeBasicAuth(String username, String password) {
        byte[] encoded;
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        String auth = username + ':' + password;
        try {
            encoded = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to encode basic authentication token", e);
        }
        return "Basic " + new String(encoded, StandardCharsets.UTF_8);
    }

    public static boolean isPrivacyGuaranteed(SecurityLevel securityLevel) {
        return SecurityLevel.PRIVACY_AND_INTEGRITY == securityLevel;
    }

    public static CallCredentials requirePrivacy(CallCredentials2 callCredentials) {
        return new RequirePrivacyCallCredentials(callCredentials);
    }

    public static CallCredentials includeWhenPrivate(CallCredentials2 callCredentials) {
        return new IncludeWhenPrivateCallCredentials(callCredentials);
    }

    private CallCredentialsHelper() {
    }

    private static final class IncludeWhenPrivateCallCredentials
    extends CallCredentials2 {
        private final CallCredentials2 callCredentials;

        IncludeWhenPrivateCallCredentials(CallCredentials2 callCredentials) {
            this.callCredentials = callCredentials;
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials2.MetadataApplier applier) {
            if (CallCredentialsHelper.isPrivacyGuaranteed(requestInfo.getSecurityLevel())) {
                this.callCredentials.applyRequestMetadata(requestInfo, appExecutor, applier);
            }
        }

        public void thisUsesUnstableApi() {
        }
    }

    private static final class RequirePrivacyCallCredentials
    extends CallCredentials2 {
        private static final Status STATUS_LACKING_PRIVACY = Status.UNAUTHENTICATED.withDescription("Connection security level does not ensure credential privacy");
        private final CallCredentials2 callCredentials;

        RequirePrivacyCallCredentials(CallCredentials2 callCredentials) {
            this.callCredentials = callCredentials;
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials2.MetadataApplier applier) {
            if (CallCredentialsHelper.isPrivacyGuaranteed(requestInfo.getSecurityLevel())) {
                this.callCredentials.applyRequestMetadata(requestInfo, appExecutor, applier);
            } else {
                applier.fail(STATUS_LACKING_PRIVACY);
            }
        }

        public void thisUsesUnstableApi() {
        }
    }

    private static final class StaticSecurityHeaderCallCredentials
    extends CallCredentials2 {
        private final Metadata extraHeaders;

        StaticSecurityHeaderCallCredentials(Metadata extraHeaders) {
            this.extraHeaders = Objects.requireNonNull(extraHeaders, "extraHeaders");
        }

        public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials2.MetadataApplier applier) {
            applier.apply(this.extraHeaders);
        }

        public void thisUsesUnstableApi() {
        }
    }
}

