/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.config;

import java.net.URI;
import java.util.List;
import net.devh.boot.grpc.client.config.NegotiationType;

public class GrpcChannelProperties {
    public static final GrpcChannelProperties DEFAULT = new GrpcChannelProperties();
    private URI address = null;
    private boolean enableKeepAlive = false;
    private boolean keepAliveWithoutCalls = false;
    private long keepAliveTime = 60L;
    private long keepAliveTimeout = 20L;
    private Integer maxInboundMessageSize = null;
    private boolean fullStreamDecompression = false;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private final Security security = new Security();

    public void setAddress(String uri) {
        this.address = URI.create(uri);
    }

    @Deprecated
    public void setHost(String host) {
        throw new UnsupportedOperationException("Use the 'address' attribute with 'static://host1:port1,...,hostn:portn' instead");
    }

    @Deprecated
    public void setHost(List<String> hosts) {
        throw new UnsupportedOperationException("Use the 'address' attribute with 'static://host1:port1,...,hostn:portn' instead");
    }

    @Deprecated
    public void setPort(String port) {
        throw new UnsupportedOperationException("Use the 'address' attribute with 'static://host1:port1,...,hostn:portn' instead");
    }

    @Deprecated
    public void setPort(List<String> ports) {
        throw new UnsupportedOperationException("Use the 'address' attribute with 'static://host1:port1,...,hostn:portn' instead");
    }

    public Integer getMaxInboundMessageSize() {
        if (this.maxInboundMessageSize != null && this.maxInboundMessageSize == -1) {
            this.maxInboundMessageSize = Integer.MAX_VALUE;
        }
        return this.maxInboundMessageSize;
    }

    public URI getAddress() {
        return this.address;
    }

    public boolean isEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean isFullStreamDecompression() {
        return this.fullStreamDecompression;
    }

    public NegotiationType getNegotiationType() {
        return this.negotiationType;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setEnableKeepAlive(boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public void setKeepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setMaxInboundMessageSize(Integer maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public void setFullStreamDecompression(boolean fullStreamDecompression) {
        this.fullStreamDecompression = fullStreamDecompression;
    }

    public void setNegotiationType(NegotiationType negotiationType) {
        this.negotiationType = negotiationType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcChannelProperties)) {
            return false;
        }
        GrpcChannelProperties other = (GrpcChannelProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$address = this.getAddress();
        URI other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        if (this.isEnableKeepAlive() != other.isEnableKeepAlive()) {
            return false;
        }
        if (this.isKeepAliveWithoutCalls() != other.isKeepAliveWithoutCalls()) {
            return false;
        }
        if (this.getKeepAliveTime() != other.getKeepAliveTime()) {
            return false;
        }
        if (this.getKeepAliveTimeout() != other.getKeepAliveTimeout()) {
            return false;
        }
        Integer this$maxInboundMessageSize = this.getMaxInboundMessageSize();
        Integer other$maxInboundMessageSize = other.getMaxInboundMessageSize();
        if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !((Object)this$maxInboundMessageSize).equals(other$maxInboundMessageSize)) {
            return false;
        }
        if (this.isFullStreamDecompression() != other.isFullStreamDecompression()) {
            return false;
        }
        NegotiationType this$negotiationType = this.getNegotiationType();
        NegotiationType other$negotiationType = other.getNegotiationType();
        if (this$negotiationType == null ? other$negotiationType != null : !((Object)((Object)this$negotiationType)).equals((Object)other$negotiationType)) {
            return false;
        }
        Security this$security = this.getSecurity();
        Security other$security = other.getSecurity();
        return !(this$security == null ? other$security != null : !((Object)this$security).equals(other$security));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcChannelProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        result = result * 59 + (this.isEnableKeepAlive() ? 79 : 97);
        result = result * 59 + (this.isKeepAliveWithoutCalls() ? 79 : 97);
        long $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + (int)($keepAliveTime >>> 32 ^ $keepAliveTime);
        long $keepAliveTimeout = this.getKeepAliveTimeout();
        result = result * 59 + (int)($keepAliveTimeout >>> 32 ^ $keepAliveTimeout);
        Integer $maxInboundMessageSize = this.getMaxInboundMessageSize();
        result = result * 59 + ($maxInboundMessageSize == null ? 43 : ((Object)$maxInboundMessageSize).hashCode());
        result = result * 59 + (this.isFullStreamDecompression() ? 79 : 97);
        NegotiationType $negotiationType = this.getNegotiationType();
        result = result * 59 + ($negotiationType == null ? 43 : ((Object)((Object)$negotiationType)).hashCode());
        Security $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        return result;
    }

    public String toString() {
        return "GrpcChannelProperties(address=" + this.getAddress() + ", enableKeepAlive=" + this.isEnableKeepAlive() + ", keepAliveWithoutCalls=" + this.isKeepAliveWithoutCalls() + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", fullStreamDecompression=" + this.isFullStreamDecompression() + ", negotiationType=" + (Object)((Object)this.getNegotiationType()) + ", security=" + this.getSecurity() + ")";
    }

    public static class Security {
        private boolean clientAuthEnabled = false;
        private String certificateChainPath = null;
        private String privateKeyPath = null;
        private String trustCertCollectionPath = null;
        private String authorityOverride = null;

        public boolean isClientAuthEnabled() {
            return this.clientAuthEnabled;
        }

        public String getCertificateChainPath() {
            return this.certificateChainPath;
        }

        public String getPrivateKeyPath() {
            return this.privateKeyPath;
        }

        public String getTrustCertCollectionPath() {
            return this.trustCertCollectionPath;
        }

        public String getAuthorityOverride() {
            return this.authorityOverride;
        }

        public void setClientAuthEnabled(boolean clientAuthEnabled) {
            this.clientAuthEnabled = clientAuthEnabled;
        }

        public void setCertificateChainPath(String certificateChainPath) {
            this.certificateChainPath = certificateChainPath;
        }

        public void setPrivateKeyPath(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
        }

        public void setTrustCertCollectionPath(String trustCertCollectionPath) {
            this.trustCertCollectionPath = trustCertCollectionPath;
        }

        public void setAuthorityOverride(String authorityOverride) {
            this.authorityOverride = authorityOverride;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Security)) {
                return false;
            }
            Security other = (Security)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isClientAuthEnabled() != other.isClientAuthEnabled()) {
                return false;
            }
            String this$certificateChainPath = this.getCertificateChainPath();
            String other$certificateChainPath = other.getCertificateChainPath();
            if (this$certificateChainPath == null ? other$certificateChainPath != null : !this$certificateChainPath.equals(other$certificateChainPath)) {
                return false;
            }
            String this$privateKeyPath = this.getPrivateKeyPath();
            String other$privateKeyPath = other.getPrivateKeyPath();
            if (this$privateKeyPath == null ? other$privateKeyPath != null : !this$privateKeyPath.equals(other$privateKeyPath)) {
                return false;
            }
            String this$trustCertCollectionPath = this.getTrustCertCollectionPath();
            String other$trustCertCollectionPath = other.getTrustCertCollectionPath();
            if (this$trustCertCollectionPath == null ? other$trustCertCollectionPath != null : !this$trustCertCollectionPath.equals(other$trustCertCollectionPath)) {
                return false;
            }
            String this$authorityOverride = this.getAuthorityOverride();
            String other$authorityOverride = other.getAuthorityOverride();
            return !(this$authorityOverride == null ? other$authorityOverride != null : !this$authorityOverride.equals(other$authorityOverride));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Security;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isClientAuthEnabled() ? 79 : 97);
            String $certificateChainPath = this.getCertificateChainPath();
            result = result * 59 + ($certificateChainPath == null ? 43 : $certificateChainPath.hashCode());
            String $privateKeyPath = this.getPrivateKeyPath();
            result = result * 59 + ($privateKeyPath == null ? 43 : $privateKeyPath.hashCode());
            String $trustCertCollectionPath = this.getTrustCertCollectionPath();
            result = result * 59 + ($trustCertCollectionPath == null ? 43 : $trustCertCollectionPath.hashCode());
            String $authorityOverride = this.getAuthorityOverride();
            result = result * 59 + ($authorityOverride == null ? 43 : $authorityOverride.hashCode());
            return result;
        }

        public String toString() {
            return "GrpcChannelProperties.Security(clientAuthEnabled=" + this.isClientAuthEnabled() + ", certificateChainPath=" + this.getCertificateChainPath() + ", privateKeyPath=" + this.getPrivateKeyPath() + ", trustCertCollectionPath=" + this.getTrustCertCollectionPath() + ", authorityOverride=" + this.getAuthorityOverride() + ")";
        }
    }
}

