/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.channelfactory;

import io.grpc.LoadBalancer;
import io.grpc.NameResolver;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import net.devh.boot.grpc.client.channelfactory.AbstractChannelFactory;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelConfigurer;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorRegistry;

public class NettyChannelFactory
extends AbstractChannelFactory<NettyChannelBuilder> {
    private final LoadBalancer.Factory loadBalancerFactory;
    private final NameResolver.Factory nameResolverFactory;

    public NettyChannelFactory(GrpcChannelsProperties properties, LoadBalancer.Factory loadBalancerFactory, NameResolver.Factory nameResolverFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        super(properties, globalClientInterceptorRegistry, channelConfigurers);
        this.loadBalancerFactory = Objects.requireNonNull(loadBalancerFactory, "loadBalancerFactory");
        this.nameResolverFactory = Objects.requireNonNull(nameResolverFactory, "nameResolverFactory");
    }

    public <T extends NettyChannelFactory> NettyChannelFactory(GrpcChannelsProperties properties, LoadBalancer.Factory loadBalancerFactory, Function<T, NameResolver.Factory> nameResolverFactoryCreator, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        super(properties, globalClientInterceptorRegistry, channelConfigurers);
        this.loadBalancerFactory = loadBalancerFactory;
        this.nameResolverFactory = nameResolverFactoryCreator.apply(this);
    }

    @Override
    protected NettyChannelBuilder newChannelBuilder(String name) {
        return (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)name).loadBalancerFactory(this.loadBalancerFactory)).nameResolverFactory(this.nameResolverFactory);
    }

    @Override
    protected void configureSecurity(NettyChannelBuilder builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        net.devh.boot.grpc.client.config.NegotiationType negotiationType = properties.getNegotiationType();
        builder.negotiationType(NettyChannelFactory.of(negotiationType));
        if (negotiationType != net.devh.boot.grpc.client.config.NegotiationType.PLAINTEXT) {
            String trustCertCollectionPath;
            GrpcChannelProperties.Security security = properties.getSecurity();
            String authorityOverwrite = security.getAuthorityOverride();
            if (authorityOverwrite != null && !authorityOverwrite.isEmpty()) {
                builder.overrideAuthority(authorityOverwrite);
            }
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (security.isClientAuthEnabled()) {
                File keyCertChainFile = this.toCheckedFile("keyCertChain", security.getCertificateChainPath());
                File privateKeyFile = this.toCheckedFile("privateKey", security.getPrivateKeyPath());
                sslContextBuilder.keyManager(keyCertChainFile, privateKeyFile);
            }
            if ((trustCertCollectionPath = security.getTrustCertCollectionPath()) != null && !trustCertCollectionPath.isEmpty()) {
                File trustCertCollectionFile = this.toCheckedFile("trustCertCollection", trustCertCollectionPath);
                sslContextBuilder.trustManager(trustCertCollectionFile);
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc client", e);
            }
        }
    }

    protected static NegotiationType of(net.devh.boot.grpc.client.config.NegotiationType negotiationType) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return NegotiationType.PLAINTEXT;
            }
            case PLAINTEXT_UPGRADE: {
                return NegotiationType.PLAINTEXT_UPGRADE;
            }
            case TLS: {
                return NegotiationType.TLS;
            }
        }
        throw new IllegalArgumentException("Unsupported NegotiationType: " + (Object)((Object)negotiationType));
    }
}

