/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.autoconfigure;

import io.grpc.CallCredentials;
import net.devh.boot.grpc.client.autoconfigure.GrpcClientAutoConfiguration;
import net.devh.boot.grpc.client.inject.StubTransformer;
import net.devh.boot.grpc.client.security.CallCredentialsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={GrpcClientAutoConfiguration.class})
public class GrpcClientSecurityAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientSecurityAutoConfiguration.class);

    @ConditionalOnSingleCandidate(value=CallCredentials.class)
    @ConditionalOnMissingBean
    @Bean
    StubTransformer stubCallCredentialsTransformer(CallCredentials credentials) {
        log.info("Found single CallCredentials in the context, automatically using it for all stubs");
        return CallCredentialsHelper.fixedCredentialsStubTransformer(credentials);
    }
}

