/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.stubfactory;

import io.grpc.Channel;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.Method;
import net.devh.boot.grpc.client.stubfactory.StubFactory;
import org.springframework.beans.BeanInstantiationException;

public abstract class StandardJavaGrpcStubFactory
implements StubFactory {
    @Override
    public AbstractStub<?> createStub(Class<? extends AbstractStub<?>> stubType, Channel channel) {
        try {
            String methodName = this.getFactoryMethodName();
            Class<?> enclosingClass = stubType.getEnclosingClass();
            Method factoryMethod = enclosingClass.getMethod(methodName, Channel.class);
            return stubType.cast(factoryMethod.invoke(null, channel));
        }
        catch (Exception e) {
            throw new BeanInstantiationException(stubType, "Failed to create gRPC client", (Throwable)e);
        }
    }

    protected abstract String getFactoryMethodName();
}

