/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.devh.boot.grpc.client.nameresolver.StaticNameResolver;

public class StaticNameResolverProvider
extends NameResolverProvider {
    public static final String STATIC_SCHEME = "static";
    private static final Pattern PATTERN_COMMA = Pattern.compile(",");

    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (STATIC_SCHEME.equals(targetUri.getScheme())) {
            return this.of(targetUri.getAuthority(), args.getDefaultPort());
        }
        return null;
    }

    private NameResolver of(String targetAuthority, int defaultPort) {
        Objects.requireNonNull(targetAuthority, "targetAuthority");
        String[] hosts = PATTERN_COMMA.split(targetAuthority);
        ArrayList<EquivalentAddressGroup> targets = new ArrayList<EquivalentAddressGroup>(hosts.length);
        for (String host : hosts) {
            URI uri = URI.create("//" + host);
            int port = uri.getPort();
            if (port == -1) {
                port = defaultPort;
            }
            targets.add(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(uri.getHost(), port)));
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one target, but was: " + targetAuthority);
        }
        return new StaticNameResolver(targetAuthority, targets);
    }

    public String getDefaultScheme() {
        return STATIC_SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 4;
    }

    public String toString() {
        return "StaticNameResolverProvider [scheme=" + this.getDefaultScheme() + "]";
    }
}

