/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.interceptor;

import com.google.common.collect.Maps;
import io.grpc.ClientInterceptor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorConfigurer;
import net.devh.boot.grpc.client.interceptor.GrpcGlobalClientInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AnnotationGlobalClientInterceptorConfigurer
implements GlobalClientInterceptorConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationGlobalClientInterceptorConfigurer.class);
    private final ApplicationContext applicationContext;

    public AnnotationGlobalClientInterceptorConfigurer(ApplicationContext applicationContext) {
        this.applicationContext = Objects.requireNonNull(applicationContext, "applicationContext");
    }

    protected Map<String, ClientInterceptor> getClientInterceptorBeans() {
        return Maps.transformValues((Map)this.applicationContext.getBeansWithAnnotation(GrpcGlobalClientInterceptor.class), ClientInterceptor.class::cast);
    }

    @Override
    public void configureClientInterceptors(List<ClientInterceptor> interceptors) {
        for (Map.Entry<String, ClientInterceptor> entry : this.getClientInterceptorBeans().entrySet()) {
            ClientInterceptor interceptor = entry.getValue();
            log.debug("Registering GlobalClientInterceptor: {} ({})", (Object)entry.getKey(), (Object)interceptor);
            interceptors.add(interceptor);
        }
    }
}

