/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.netty.NettyChannelBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.devh.springboot.autoconfigure.grpc.client.DiscoveryClientResolverFactory;
import net.devh.springboot.autoconfigure.grpc.client.GlobalClientInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelFactory;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelProperties;
import net.devh.springboot.autoconfigure.grpc.client.GrpcChannelsProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class DiscoveryClientChannelFactory
implements GrpcChannelFactory {
    private final GrpcChannelsProperties properties;
    private final DiscoveryClient client;
    private final LoadBalancer.Factory loadBalancerFactory;
    private final GlobalClientInterceptorRegistry globalClientInterceptorRegistry;

    public DiscoveryClientChannelFactory(GrpcChannelsProperties properties, DiscoveryClient client, LoadBalancer.Factory loadBalancerFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry) {
        this.properties = properties;
        this.client = client;
        this.loadBalancerFactory = loadBalancerFactory;
        this.globalClientInterceptorRegistry = globalClientInterceptorRegistry;
    }

    @Override
    public Channel createChannel(String name) {
        return this.createChannel(name, null);
    }

    @Override
    public Channel createChannel(String name, List<ClientInterceptor> interceptors) {
        GrpcChannelProperties channelProperties = this.properties.getChannel(name);
        ManagedChannel channel = ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)name).loadBalancerFactory(this.loadBalancerFactory)).nameResolverFactory((NameResolver.Factory)new DiscoveryClientResolverFactory(this.client))).usePlaintext(this.properties.getChannel(name).isPlaintext()).enableKeepAlive(channelProperties.isEnableKeepAlive(), channelProperties.getKeepAliveDelay(), TimeUnit.SECONDS, channelProperties.getKeepAliveTimeout(), TimeUnit.SECONDS).build();
        List<ClientInterceptor> globalInterceptorList = this.globalClientInterceptorRegistry.getClientInterceptors();
        HashSet<ClientInterceptor> interceptorSet = new HashSet<ClientInterceptor>();
        if (globalInterceptorList != null && !globalInterceptorList.isEmpty()) {
            interceptorSet.addAll(globalInterceptorList);
        }
        if (interceptors != null && !interceptors.isEmpty()) {
            interceptorSet.addAll(interceptors);
        }
        return ClientInterceptors.intercept((Channel)channel, (List)Lists.newArrayList(interceptorSet));
    }
}

